/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class ImageLoader
implements Runnable {
    private final TreePanel _tp;
    private static final BufferedImage PLACEHOLDER = new BufferedImage(1, 1, 1);
    private static final boolean DEBUG = false;

    public ImageLoader(TreePanel tp) {
        this._tp = tp;
    }

    @Override
    public void run() {
        this.load();
    }

    private void load() {
        Hashtable<String, BufferedImage> image_map = null;
        if (this._tp.getImageMap() != null) {
            image_map = this._tp.getImageMap();
        } else {
            image_map = new Hashtable();
            this._tp.setImageMap(image_map);
        }
        PhylogenyNodeIterator it = this._tp.getPhylogeny().iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            if (!node.getNodeData().isHasTaxonomy() || node.getNodeData().getTaxonomy().getUris() == null || node.getNodeData().getTaxonomy().getUris().isEmpty()) continue;
            ArrayList<Uri> us = new ArrayList<Uri>();
            for (Taxonomy t : node.getNodeData().getTaxonomies()) {
                for (Uri uri : t.getUris()) {
                    us.add(uri);
                }
            }
            for (Uri uri : us) {
                if (uri == null) continue;
                String type = uri.getType().toLowerCase();
                String uri_str = uri.getValue().toString().toLowerCase();
                if (image_map.containsKey(uri_str) || !type.equals("image") && !type.equals("img") && !type.equals("photo") && !type.equals("picture") && !uri_str.endsWith(".jpg") && !uri_str.endsWith(".jpeg") && !uri_str.endsWith(".png") && !uri_str.endsWith(".gif") && !uri_str.endsWith(".bmp")) continue;
                image_map.put(uri_str, PLACEHOLDER);
                BufferedImage bi = null;
                try {
                    bi = ImageIO.read(uri.getValue().toURL());
                }
                catch (MalformedURLException e) {
                    AptxUtil.printWarningMessage("Archaeopteryx", "could not load image from \"" + uri.getValue() + "\": Malformed URL Exception: " + e.getLocalizedMessage());
                }
                catch (IOException e) {
                    AptxUtil.printWarningMessage("Archaeopteryx", "could not load image from \"" + uri.getValue() + "\": IO Exception: " + e.getLocalizedMessage());
                }
                catch (CMMException e) {
                    AptxUtil.printWarningMessage("Archaeopteryx", "could not load image from \"" + uri.getValue() + "\": CMMException: " + e.getLocalizedMessage());
                }
                if (bi != null) {
                    image_map.put(uri_str, bi);
                    this._tp.repaint();
                    continue;
                }
                image_map.remove(uri_str);
            }
        }
    }
}

