/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

final class PdfExporter {
    private static final int HEIGHT_LIMIT = 100;
    private static final int WIDTH_LIMIT = 60;

    private PdfExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String writePhylogenyToPdf(String file_name, TreePanel tree_panel, int width, int height) throws IOException {
        Phylogeny phylogeny;
        if (height < 100) {
            height = 100;
        }
        if (width < 60) {
            width = 60;
        }
        if ((phylogeny = tree_panel.getPhylogeny()) == null || phylogeny.isEmpty()) {
            return "";
        }
        if (tree_panel.getMainPanel().getTreeFontSet().getSmallFont().getSize() < 1) {
            throw new IOException("fonts are too small for PDF export");
        }
        File file = new File(file_name);
        if (file.isDirectory()) {
            throw new IOException("[" + file_name + "] is a directory");
        }
        Document document = new Document();
        document.setPageSize(new Rectangle((float)width, (float)height));
        document.setMargins(30.0f, 30.0f, 50.0f, 50.0f);
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file_name));
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        document.open();
        DefaultFontMapper mapper = new DefaultFontMapper();
        FontFactory.registerDirectories();
        if (ForesterUtil.isWindows()) {
            mapper.insertDirectory("C:\\WINDOWS\\Fonts\\");
        } else if (ForesterUtil.isMac()) {
            mapper.insertDirectory("/Library/Fonts/");
            mapper.insertDirectory("/System/Library/Fonts/");
        } else {
            mapper.insertDirectory("/usr/X/lib/X11/fonts/TrueType/");
            mapper.insertDirectory("/usr/X/lib/X11/fonts/Type1/");
            mapper.insertDirectory("/usr/share/fonts/default/TrueType/");
            mapper.insertDirectory("/usr/share/fonts/default/Type1/");
        }
        PdfContentByte cb = writer.getDirectContent();
        Graphics2D g2 = cb.createGraphics((float)width, (float)height, (FontMapper)mapper);
        try {
            tree_panel.paintPhylogeny(g2, true, false, width, height, 0, 0);
        }
        catch (Exception e) {
            AptxUtil.unexpectedException(e);
        }
        finally {
            try {
                g2.dispose();
                document.close();
            }
            catch (Exception e) {}
        }
        String msg = file.toString();
        if (width > 0 && height > 0) {
            msg = msg + " [size: " + width + ", " + height + "]";
        }
        return msg;
    }
}

