/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class get_loss_nodes {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("get_loss_nodes: Wrong number of arguments");
            System.out.println("Usage: \"get_loss_nodes <phylogeny file> <file with characters>\"");
            System.exit(-1);
        }
        File phylogeny_infile = new File(args[0]);
        Phylogeny p = null;
        try {
            PhylogenyParser pp = ParserUtils.createParserDependingOnFileType(phylogeny_infile, true);
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            p = factory.create(phylogeny_infile, pp)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        List<String> chars = null;
        try {
            chars = ForesterUtil.file2list(new File(args[1]));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        for (String c : chars) {
            boolean found = false;
            PhylogenyNodeIterator it = p.iteratorPostorder();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                if (!n.getNodeData().getBinaryCharacters().getLostCharacters().contains(c)) continue;
                if (n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) {
                    System.out.println(c + "\t" + n.getNodeData().getTaxonomy().getScientificName());
                } else {
                    System.out.println(c + "\t" + n.getName());
                }
                found = true;
            }
            if (found) continue;
            System.out.println(c + "\tnever lost");
        }
    }
}

