/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class check_fasta {
    private static final String PRG_NAME = "check_fasta";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "131202";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (args.length != 2) {
            check_fasta.argumentsError();
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        File indir = cla.getFile(0);
        File outdir = cla.getFile(1);
        if (!indir.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, indir + " is not a directory");
        }
        if (!outdir.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, outdir + " is not a directory");
        }
        File[] list_of_files = indir.listFiles();
        ArrayList<File> infiles = new ArrayList<File>();
        for (File file : list_of_files) {
            if (!file.isFile() || !file.canRead() || !file.toString().toLowerCase().endsWith(".fasta") && !file.toString().toLowerCase().endsWith(".fas")) continue;
            infiles.add(file);
        }
        Collections.sort(infiles);
        int c = 0;
        for (File infile : infiles) {
            System.out.println(++c + "/" + infiles.size() + ": " + infile);
            check_fasta.execute(outdir, infile);
        }
    }

    private static void execute(File outdir, File infile) {
        File outfile = new File(outdir.getAbsolutePath().toString() + "/" + infile.getName());
        if (outfile.exists()) {
            System.out.println(outfile + " already exists");
        } else {
            try {
                List<MolecularSequence> seqs = FastaParser.parse(new FileInputStream(infile));
                HashMap<String, Short> names = new HashMap<String, Short>();
                int duplicates = 0;
                for (MolecularSequence seq : seqs) {
                    if (!check_fasta.procSeq(infile.toString(), names, seq)) continue;
                    ++duplicates;
                }
                if (duplicates > 0) {
                    SequenceWriter.writeSeqs(seqs, outfile, SequenceWriter.SEQ_FORMAT.FASTA, 60);
                }
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
        }
    }

    private static boolean procSeq(String infile, Map<String, Short> names, MolecularSequence seq) {
        boolean duplicate = false;
        String name = seq.getIdentifier();
        if (!names.containsKey(name)) {
            names.put(name, (short)1);
        } else {
            duplicate = true;
            short i = names.get(name);
            ((BasicSequence)seq).setIdentifier(name + "_" + i);
            names.put(name, (short)(i + 1));
            System.out.println("  " + infile + " " + i + ": " + seq.getIdentifier());
        }
        return duplicate;
    }

    private static void argumentsError() {
        System.out.println("check_fasta <indir> <outdir>");
        System.out.println();
        System.exit(-1);
    }
}

