/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import javax.tools.StandardLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.Main;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class BatchAnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private List<Processor> _setProcessors = null;
    private Iterator<Processor> _setProcessorIter = null;
    private List<String> _commandLineProcessors;
    private Iterator<String> _commandLineProcessorIter = null;
    private ServiceLoader<Processor> _serviceLoader = null;
    private Iterator<Processor> _serviceLoaderIter;
    private ClassLoader _procLoader;
    private static final boolean VERBOSE_PROCESSOR_DISCOVERY = true;
    private boolean _printProcessorDiscovery = false;

    @Override
    public void configure(Object batchCompiler, String[] commandLineArguments) {
        if (this._processingEnv != null) {
            throw new IllegalStateException("Calling configure() more than once on an AnnotationProcessorManager is not supported");
        }
        BatchProcessingEnvImpl processingEnv = new BatchProcessingEnvImpl(this, (Main)batchCompiler, commandLineArguments);
        this._processingEnv = processingEnv;
        this._procLoader = processingEnv.getFileManager().getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        this.parseCommandLine(commandLineArguments);
        this._round = 0;
    }

    private void parseCommandLine(String[] commandLineArguments) {
        ArrayList<String> commandLineProcessors = null;
        int i = 0;
        while (i < commandLineArguments.length) {
            String option = commandLineArguments[i];
            if ("-XprintProcessorInfo".equals(option)) {
                this._printProcessorInfo = true;
                this._printProcessorDiscovery = true;
            } else if ("-XprintRounds".equals(option)) {
                this._printRounds = true;
            } else if ("-processor".equals(option)) {
                commandLineProcessors = new ArrayList<String>();
                String procs = commandLineArguments[++i];
                String[] stringArray = procs.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String proc = stringArray[n2];
                    commandLineProcessors.add(proc);
                    ++n2;
                }
                break;
            }
            ++i;
        }
        this._commandLineProcessors = commandLineProcessors;
        if (this._commandLineProcessors != null) {
            this._commandLineProcessorIter = this._commandLineProcessors.iterator();
        }
    }

    @Override
    public ProcessorInfo discoverNextProcessor() {
        block18: {
            block17: {
                if (this._setProcessors == null) break block17;
                if (this._setProcessorIter.hasNext()) {
                    Processor p = this._setProcessorIter.next();
                    p.init(this._processingEnv);
                    ProcessorInfo pi = new ProcessorInfo(p);
                    this._processors.add(pi);
                    if (this._printProcessorDiscovery && this._out != null) {
                        this._out.println("API specified processor: " + pi);
                    }
                    return pi;
                }
                return null;
            }
            if (this._commandLineProcessors == null) break block18;
            if (this._commandLineProcessorIter.hasNext()) {
                String proc = this._commandLineProcessorIter.next();
                try {
                    Class<?> clazz = this._procLoader.loadClass(proc);
                    Object o = clazz.newInstance();
                    Processor p = (Processor)o;
                    p.init(this._processingEnv);
                    ProcessorInfo pi = new ProcessorInfo(p);
                    this._processors.add(pi);
                    if (this._printProcessorDiscovery && this._out != null) {
                        this._out.println("Command line specified processor: " + pi);
                    }
                    return pi;
                }
                catch (Exception e) {
                    throw new AbortCompilation(null, (Throwable)e);
                }
            }
            return null;
        }
        try {
            String resPath = "META-INF/services/" + Processor.class.getName();
            Enumeration<URL> resources = this._procLoader.getResources(resPath);
            if (resources != null) {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    this.parse(url);
                }
            }
            if (this._serviceLoader == null) {
                this._serviceLoader = ServiceLoader.load(Processor.class, this._procLoader);
                this._serviceLoaderIter = this._serviceLoader.iterator();
            }
            try {
                if (this._serviceLoaderIter.hasNext()) {
                    Processor p = this._serviceLoaderIter.next();
                    p.init(this._processingEnv);
                    ProcessorInfo pi = new ProcessorInfo(p);
                    this._processors.add(pi);
                    if (this._printProcessorDiscovery && this._out != null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Discovered processor service ");
                        sb.append(pi);
                        sb.append("\n  supporting ");
                        sb.append(pi.getSupportedAnnotationTypesAsString());
                        sb.append("\n  in ");
                        sb.append(this.getProcessorLocation(p));
                        this._out.println(sb.toString());
                    }
                    return pi;
                }
            }
            catch (ServiceConfigurationError e) {
                throw new AbortCompilation(null, (Throwable)e);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private Iterator<String> parse(URL u) throws ServiceConfigurationError, IOException {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            try {
                in = u.openStream();
                r = new BufferedReader(new InputStreamReader(in, "utf-8"));
                int lc = 1;
                while ((lc = this.parseLine(r, lc, names)) >= 0) {
                }
            }
            catch (IOException x) {
                throw new IllegalStateException("Error reading configuration file", x);
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                throw new IllegalStateException("Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    private int parseLine(BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                throw new IllegalStateException("Illegal configuration-file syntax");
            }
            int cp = ln.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                throw new IllegalStateException("Illegal provider-class name: " + ln);
            }
            int i = Character.charCount(cp);
            while (i < n) {
                cp = ln.codePointAt(i);
                if (!Character.isJavaIdentifierPart(cp) && cp != 46) {
                    throw new IllegalStateException("Illegal provider-class name: " + ln);
                }
                i += Character.charCount(cp);
            }
            if (!names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private String getProcessorLocation(Processor p) {
        String location;
        boolean isMember = false;
        Class<?> outerClass = p.getClass();
        StringBuilder innerName = new StringBuilder();
        while (outerClass.isMemberClass()) {
            innerName.insert(0, outerClass.getSimpleName());
            innerName.insert(0, '$');
            isMember = true;
            outerClass = outerClass.getEnclosingClass();
        }
        String path = outerClass.getName();
        path = path.replace('.', '/');
        if (isMember) {
            path = String.valueOf(path) + innerName;
        }
        if ((location = this._procLoader.getResource(path = String.valueOf(path) + ".class").toString()).endsWith(path)) {
            location = location.substring(0, location.length() - path.length());
        }
        return location;
    }

    @Override
    public void reportProcessorException(Processor p, Exception e) {
        throw new AbortCompilation(null, (Throwable)e);
    }

    @Override
    public void setProcessors(Object[] processors) {
        if (!this._isFirstRound) {
            throw new IllegalStateException("setProcessors() cannot be called after processing has begun");
        }
        this._setProcessors = new ArrayList<Processor>(processors.length);
        Object[] objectArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Processor p = (Processor)o;
            this._setProcessors.add(p);
            ++n2;
        }
        this._setProcessorIter = this._setProcessors.iterator();
        this._commandLineProcessors = null;
        this._commandLineProcessorIter = null;
    }
}

