/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Table;
import org.asciidoctor.jruby.ast.impl.DocumentImpl;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.asciidoctor.jruby.ast.impl.StructuralNodeImpl;
import org.jruby.runtime.builtin.IRubyObject;

public class CellImpl
extends StructuralNodeImpl
implements Cell {
    public CellImpl(IRubyObject rubyNode) {
        super(rubyNode);
    }

    public Column getColumn() {
        return (Column)this.getParent();
    }

    public int getColspan() {
        return this.getInt("colspan", new Object[0]);
    }

    public int getRowspan() {
        return this.getInt("rowspan", new Object[0]);
    }

    public String getText() {
        return this.getString("text", new Object[0]);
    }

    public String getSource() {
        return this.getString("@text", new Object[0]);
    }

    public void setSource(String source) {
        this.setString("@text", source);
    }

    @Override
    public Object getContent() {
        return this.toJava(this.getRubyProperty("content", new Object[0]));
    }

    @Override
    public String getStyle() {
        return this.getSymbol("style", new Object[0]);
    }

    @Override
    public void setStyle(String style) {
        this.setSymbol("style", style);
    }

    public Table.HorizontalAlignment getHorizontalAlignment() {
        return Table.HorizontalAlignment.valueOf((String)((String)this.getAttribute("halign", "left")).toUpperCase());
    }

    public void setHorizontalAlignment(Table.HorizontalAlignment halign) {
        this.setAttribute("halign", halign.name().toLowerCase(), true);
    }

    public Table.VerticalAlignment getVerticalAlignment() {
        return Table.VerticalAlignment.valueOf((String)((String)this.getAttribute("valign", "top")).toUpperCase());
    }

    public void setVerticalAlignment(Table.VerticalAlignment valign) {
        this.setAttribute("valign", valign.name().toLowerCase(), true);
    }

    public Document getInnerDocument() {
        IRubyObject innerDocument = this.getRubyProperty("inner_document", new Object[0]);
        if (innerDocument.isNil()) {
            return null;
        }
        return (Document)NodeConverter.createASTNode(innerDocument);
    }

    public void setInnerDocument(Document document) {
        this.setRubyProperty("@inner_document", ((DocumentImpl)document).getRubyObject());
    }
}

