/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.ExecutionService;
import org.arquillian.spacelift.execution.TimeoutExecutionException;
import org.arquillian.spacelift.execution.impl.ShutdownHooks;

class FutureBasedExecution<RESULT>
implements Execution<RESULT> {
    public static final long DEFAULT_POLL_INTERVAL = 500L;
    public static final TimeUnit DEFAULT_POLL_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final Callable<RESULT> executionTask;
    private final Future<RESULT> executionFuture;
    private final ExecutionService service;
    private long pollInterval;
    private TimeUnit pollUnit;
    private boolean shouldBeFinished;

    public FutureBasedExecution(ExecutionService service, Callable<RESULT> task, Future<RESULT> future) {
        this.service = service;
        this.executionTask = task;
        this.executionFuture = future;
        this.pollInterval = 500L;
        this.pollUnit = DEFAULT_POLL_TIME_UNIT;
    }

    private static ExecutionException unwrapException(Throwable cause, String messageFormat, Object ... parameters) {
        ExecutionException deepestCause = null;
        for (Throwable current = cause; current != null; current = current.getCause()) {
            if (!(current instanceof ExecutionException)) continue;
            deepestCause = (ExecutionException)current;
        }
        if (deepestCause != null) {
            return deepestCause.prependMessage(messageFormat, parameters);
        }
        return new ExecutionException(cause, messageFormat, parameters);
    }

    private static TimeoutExecutionException unwrapExceptionAsTimeoutException(Throwable cause, String messageFormat, Object ... parameters) {
        for (Throwable current = cause; current != null; current = current.getCause()) {
            if (!(current instanceof ExecutionException)) continue;
            return new TimeoutExecutionException(current, messageFormat, parameters);
        }
        return new TimeoutExecutionException(cause, messageFormat, parameters);
    }

    public Execution<RESULT> markAsFinished() {
        this.shouldBeFinished = true;
        return this;
    }

    public Execution<RESULT> registerShutdownHook() {
        ShutdownHooks.addHookFor(this);
        return this;
    }

    public boolean isMarkedAsFinished() {
        return this.shouldBeFinished;
    }

    public boolean isFinished() {
        return this.isMarkedAsFinished() || this.executionFuture.isDone();
    }

    public boolean hasFailed() {
        return this.executionFuture.isCancelled();
    }

    public Execution<RESULT> terminate() {
        this.executionFuture.cancel(true);
        return this;
    }

    public RESULT await() throws ExecutionException {
        try {
            return this.executionFuture.get();
        }
        catch (InterruptedException e) {
            throw FutureBasedExecution.unwrapException(e, "Interrupted while executing a task", new Object[0]);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw FutureBasedExecution.unwrapException(e, "Execution of a task failed", new Object[0]);
        }
    }

    public RESULT awaitAtMost(long timeout, TimeUnit unit) {
        try {
            return this.executionFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw FutureBasedExecution.unwrapException(e, "Interrupted while executing a task", new Object[0]);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw FutureBasedExecution.unwrapException(e, "Execution of a task failed", new Object[0]);
        }
        catch (TimeoutException e) {
            throw FutureBasedExecution.unwrapExceptionAsTimeoutException(e, "Timed out after {0}{1} while executing a task", new Object[]{timeout, unit});
        }
    }

    public Execution<RESULT> reexecuteEvery(long step, TimeUnit unit) {
        this.pollInterval = step;
        this.pollUnit = unit;
        return this;
    }

    public RESULT until(long timeout, TimeUnit unit, ExecutionCondition<RESULT> condition) throws ExecutionException, TimeoutExecutionException {
        CountDownWatch countdown = new CountDownWatch(timeout, unit);
        Execution currentExecution = new FutureBasedExecution(this.service, this.executionTask, this.executionFuture);
        while (countdown.timeLeft() > 0L) {
            try {
                Object result = currentExecution.awaitAtMost(countdown.timeLeft(), countdown.getTimeUnit());
                Execution nextExecution = this.service.schedule(this.executionTask, this.pollInterval, this.pollUnit);
                if (condition.satisfiedBy(result)) {
                    try {
                        nextExecution.terminate();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    return (RESULT)result;
                }
                currentExecution = nextExecution;
            }
            catch (TimeoutExecutionException e) {}
        }
        throw new TimeoutExecutionException("Unable to trigger condition within {0} {1}.", new Object[]{timeout, unit.toString().toLowerCase()});
    }

    public RESULT awaitAtMost(CountDownWatch timeout) throws ExecutionException, TimeoutExecutionException {
        return this.awaitAtMost(timeout.timeout(), timeout.getTimeUnit());
    }

    public RESULT until(CountDownWatch timeout, ExecutionCondition<RESULT> condition) throws ExecutionException, TimeoutExecutionException {
        return this.until(timeout.timeout(), timeout.getTimeUnit(), condition);
    }
}

