/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.security.AdminPagesSecurityProperties;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.web.pac4j.CasSecurityInterceptor;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.client.direct.DirectCasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.authorization.generator.SpringSecurityPropertiesAuthorizationGenerator;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.http.client.direct.IpClient;
import org.pac4j.http.credentials.authenticator.IpRegexpAuthenticator;
import org.pac4j.http.credentials.extractor.IpExtractor;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMappingCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.WebContentInterceptor;

@Configuration(value="casSecurityContextConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasSecurityContextConfiguration
extends WebMvcConfigurerAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSecurityContextConfiguration.class);
    private static final String CAS_CLIENT_NAME = "CasClient";
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public WebContentInterceptor webContentInterceptor() {
        WebContentInterceptor interceptor = new WebContentInterceptor();
        interceptor.setCacheSeconds(0);
        interceptor.setAlwaysUseFullPath(true);
        return interceptor;
    }

    @RefreshScope
    @Bean
    public SecurityInterceptor requiresAuthenticationStatusInterceptor() {
        AdminPagesSecurityProperties secProps = this.casProperties.getAdminPagesSecurity();
        IpRegexpAuthenticator authn = new IpRegexpAuthenticator(secProps.getIp());
        IpClient ipClient = new IpClient((Authenticator)authn);
        Set headerNames = StringUtils.commaDelimitedListToSet((String)secProps.getAlternateIpHeaderName());
        IpExtractor credentialsExtractor = new IpExtractor(headerNames.toArray(new String[0]));
        ipClient.setCredentialsExtractor((CredentialsExtractor)credentialsExtractor);
        return new CasSecurityInterceptor(new Config((Client)ipClient), ipClient.getClass().getSimpleName());
    }

    @RefreshScope
    @Bean
    public Config casAdminPagesPac4jConfig() {
        try {
            AdminPagesSecurityProperties adminProps = this.casProperties.getAdminPagesSecurity();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)adminProps.getLoginUrl()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)adminProps.getService())) {
                CasConfiguration casConfig = new CasConfiguration(adminProps.getLoginUrl());
                DirectCasClient client = new DirectCasClient(casConfig);
                client.setName(CAS_CLIENT_NAME);
                Config cfg = new Config(adminProps.getService(), (Client)client);
                if (adminProps.getUsers() == null) {
                    LOGGER.warn("List of authorized users for admin pages security is not defined. Allowing access for all authenticated users");
                    client.setAuthorizationGenerator((AuthorizationGenerator)new DefaultCasAuthorizationGenerator());
                    cfg.setAuthorizer((Authorizer)new IsAuthenticatedAuthorizer());
                } else {
                    Resource file = ResourceUtils.prepareClasspathResourceIfNeeded((Resource)adminProps.getUsers());
                    if (file != null && file.exists()) {
                        LOGGER.debug("Loading list of authorized users from [{}]", (Object)file);
                        Properties properties = new Properties();
                        properties.load(file.getInputStream());
                        client.setAuthorizationGenerator((AuthorizationGenerator)new SpringSecurityPropertiesAuthorizationGenerator(properties));
                        cfg.setAuthorizer((Authorizer)new RequireAnyRoleAuthorizer(adminProps.getAdminRoles()));
                    }
                }
                return cfg;
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return new Config();
    }

    @RefreshScope
    @Bean
    public SecurityInterceptor requiresAuthenticationStatusAdminEndpointsInterceptor() {
        Config cfg = this.casAdminPagesPac4jConfig();
        if (cfg.getClients() == null) {
            return this.requiresAuthenticationStatusInterceptor();
        }
        CasSecurityInterceptor interceptor = new CasSecurityInterceptor(cfg, CAS_CLIENT_NAME, "securityHeaders,csrfToken,".concat(this.getAuthorizerName()));
        return interceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.statusInterceptor()).addPathPatterns(new String[]{"/status/**"});
        registry.addInterceptor((HandlerInterceptor)this.webContentInterceptor()).addPathPatterns(new String[]{"/*"});
    }

    @Bean
    public HandlerInterceptorAdapter statusInterceptor() {
        return new CasAdminStatusInterceptor();
    }

    @RefreshScope
    @Bean
    public EndpointHandlerMappingCustomizer mappingCustomizer() {
        return mapping -> mapping.setInterceptors(new Object[]{this.statusInterceptor()});
    }

    private String getAuthorizerName() {
        if (this.casProperties.getAdminPagesSecurity().getUsers() == null) {
            return IsAuthenticatedAuthorizer.class.getSimpleName();
        }
        return RequireAnyRoleAuthorizer.class.getSimpleName();
    }

    public class CasAdminStatusInterceptor
    extends HandlerInterceptorAdapter {
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            String requestPath = request.getRequestURI();
            Pattern pattern = Pattern.compile("/status(/)*$");
            if (pattern.matcher(requestPath).find()) {
                return CasSecurityContextConfiguration.this.requiresAuthenticationStatusInterceptor().preHandle(request, response, handler);
            }
            return CasSecurityContextConfiguration.this.requiresAuthenticationStatusAdminEndpointsInterceptor().preHandle(request, response, handler);
        }

        public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
            String requestPath = request.getRequestURI();
            Pattern pattern = Pattern.compile("/status(/)*$");
            if (pattern.matcher(requestPath).find()) {
                CasSecurityContextConfiguration.this.requiresAuthenticationStatusInterceptor().postHandle(request, response, handler, modelAndView);
            }
            CasSecurityContextConfiguration.this.requiresAuthenticationStatusAdminEndpointsInterceptor().postHandle(request, response, handler, modelAndView);
        }
    }
}

