/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.x509.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.support.rest.factory.DefaultCredentialFactory;
import org.apereo.cas.util.crypto.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.MultiValueMap;

public class X509CredentialFactory
extends DefaultCredentialFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CredentialFactory.class);
    private static final String CERTIFICATE = "cert";

    public Credential fromRequestBody(MultiValueMap<String, String> requestBody) {
        String cert = (String)requestBody.getFirst((Object)CERTIFICATE);
        LOGGER.debug("Certificate in the request body: [{}]", (Object)cert);
        if (StringUtils.isBlank((CharSequence)cert)) {
            return super.fromRequestBody(requestBody);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(cert.getBytes());
        InputStreamResource iso = new InputStreamResource((InputStream)is);
        X509Certificate certificate = CertUtils.readCertificate((InputStreamSource)iso);
        X509CertificateCredential credential = new X509CertificateCredential(new X509Certificate[]{certificate});
        credential.setCertificate(certificate);
        return credential;
    }
}

