/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="registeredServiceResourceRestController")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RegisteredServiceResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceResource.class);
    private final ServicesManager servicesManager;
    private final CentralAuthenticationService centralAuthenticationService;
    private final String attributeName;
    private final String attributeValue;

    public RegisteredServiceResource(ServicesManager servicesManager, CentralAuthenticationService centralAuthenticationService, String attributeName, String attributeValue) {
        this.servicesManager = servicesManager;
        this.centralAuthenticationService = centralAuthenticationService;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    @PostMapping(value={"/v1/services/add/{tgtId:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createService(@ModelAttribute ServiceDataHolder serviceDataHolder, @PathVariable(value="tgtId") String tgtId) {
        try {
            if (StringUtils.isBlank((CharSequence)this.attributeName) || StringUtils.isBlank((CharSequence)this.attributeValue)) {
                throw new IllegalArgumentException("Attribute name and/or value must be configured");
            }
            TicketGrantingTicket ticket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(tgtId, TicketGrantingTicket.class);
            if (ticket == null || ticket.isExpired()) {
                throw new InvalidTicketException("Ticket-granting ticket " + tgtId + " is not found");
            }
            Map attributes = ticket.getAuthentication().getPrincipal().getAttributes();
            if (attributes.containsKey(this.attributeName)) {
                HashSet<String> attributeValuesToCompare = new HashSet<String>();
                Object value = attributes.get(this.attributeName);
                if (value instanceof Collection) {
                    attributeValuesToCompare.addAll((Collection)value);
                } else {
                    attributeValuesToCompare.add(value.toString());
                }
                if (attributeValuesToCompare.contains(this.attributeValue)) {
                    RegisteredService service = serviceDataHolder.getRegisteredService();
                    RegisteredService savedService = this.servicesManager.save(service);
                    return new ResponseEntity((Object)String.valueOf(savedService.getId()), HttpStatus.OK);
                }
            }
            throw new IllegalArgumentException("Request is not authorized");
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"TicketGrantingTicket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    private static class ServiceDataHolder
    implements Serializable {
        private static final long serialVersionUID = 3035541944428412672L;
        private String serviceId;
        private String name;
        private String description;
        private int evaluationOrder = Integer.MAX_VALUE;
        private boolean enabled;
        private boolean ssoEnabled;

        private ServiceDataHolder() {
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public void setName(String serviceName) {
            this.name = serviceName;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setEvaluationOrder(int evaluationOrder) {
            this.evaluationOrder = evaluationOrder;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setSsoEnabled(boolean ssoEnabled) {
            this.ssoEnabled = ssoEnabled;
        }

        public RegisteredService getRegisteredService() {
            if (StringUtils.isBlank((CharSequence)this.serviceId) || StringUtils.isBlank((CharSequence)this.name) || StringUtils.isBlank((CharSequence)this.description)) {
                throw new IllegalArgumentException("Service name/description/id is missing");
            }
            RegexRegisteredService service = new RegexRegisteredService();
            service.setServiceId(this.serviceId);
            service.setDescription(this.description);
            service.setName(this.name);
            service.setEvaluationOrder(this.evaluationOrder);
            service.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(this.enabled, this.ssoEnabled));
            return service;
        }
    }
}

