/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.support;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Version;
import lombok.Generated;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class JpaLockingStrategy
implements LockingStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaLockingStrategy.class);
    @PersistenceContext(unitName="ticketEntityManagerFactory")
    protected EntityManager entityManager;
    private final String applicationId;
    private final String uniqueId;
    private final long lockTimeout;

    public JpaLockingStrategy(String applicationId, String uniqueId, long lockTimeout) {
        this.applicationId = applicationId;
        this.uniqueId = uniqueId;
        if (lockTimeout < 0L) {
            throw new IllegalArgumentException("Lock timeout must be non-negative.");
        }
        this.lockTimeout = lockTimeout;
    }

    public void release() {
        Lock lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId, LockModeType.OPTIMISTIC);
        if (lock == null) {
            return;
        }
        String owner = lock.getUniqueId();
        if (!this.uniqueId.equals(owner)) {
            throw new IllegalStateException("Cannot release lock owned by " + owner);
        }
        lock.setUniqueId(null);
        lock.setExpirationDate(null);
        LOGGER.debug("Releasing [{}] lock held by [{}].", (Object)this.applicationId, (Object)this.uniqueId);
        this.entityManager.persist((Object)lock);
    }

    public boolean acquire(Lock lock) {
        boolean success;
        lock.setUniqueId(this.uniqueId);
        if (this.lockTimeout > 0L) {
            lock.setExpirationDate(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.lockTimeout));
        } else {
            lock.setExpirationDate(null);
        }
        try {
            if (lock.getApplicationId() != null) {
                this.entityManager.merge((Object)lock);
            } else {
                lock.setApplicationId(this.applicationId);
                this.entityManager.persist((Object)lock);
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[{}] could not obtain [{}] lock.", new Object[]{this.uniqueId, this.applicationId, e});
            }
            LOGGER.info("[{}] could not obtain [{}] lock.", (Object)this.uniqueId, (Object)this.applicationId);
        }
        return success;
    }

    public boolean acquire() {
        Lock lock;
        try {
            lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId, LockModeType.OPTIMISTIC);
        }
        catch (Exception e) {
            LOGGER.debug("[{}] failed querying for [{}] lock.", new Object[]{this.uniqueId, this.applicationId, e});
            return false;
        }
        boolean result = false;
        if (lock != null) {
            ZonedDateTime expDate = lock.getExpirationDate();
            if (lock.getUniqueId() == null) {
                LOGGER.debug("[{}] trying to acquire [{}] lock.", (Object)this.uniqueId, (Object)this.applicationId);
                result = this.acquire(lock);
            } else if (expDate == null || ZonedDateTime.now(ZoneOffset.UTC).isAfter(expDate)) {
                LOGGER.debug("[{}] trying to acquire expired [{}] lock.", (Object)this.uniqueId, (Object)this.applicationId);
                result = this.acquire(lock);
            }
        } else {
            LOGGER.debug("Creating [{}] lock initially held by [{}].", (Object)this.applicationId, (Object)this.uniqueId);
            result = this.acquire(new Lock());
        }
        return result;
    }

    @Generated
    public String toString() {
        return "JpaLockingStrategy(entityManager=" + this.entityManager + ", applicationId=" + this.applicationId + ", uniqueId=" + this.uniqueId + ", lockTimeout=" + this.lockTimeout + ")";
    }

    @Generated
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public long getLockTimeout() {
        return this.lockTimeout;
    }

    @Entity
    @Table(name="locks")
    public static class Lock
    implements Serializable {
        private static final long serialVersionUID = -5750740484289616656L;
        @Id
        @javax.persistence.Id
        @Column(name="application_id")
        private String applicationId;
        @Column(name="unique_id")
        private String uniqueId;
        @Column(name="expiration_date")
        private ZonedDateTime expirationDate;
        @Version
        @Column(name="lockVer", columnDefinition="integer DEFAULT 0", nullable=false)
        private final Long version = 0L;

        @Generated
        public String getApplicationId() {
            return this.applicationId;
        }

        @Generated
        public String getUniqueId() {
            return this.uniqueId;
        }

        @Generated
        public ZonedDateTime getExpirationDate() {
            return this.expirationDate;
        }

        @Generated
        public Long getVersion() {
            return this.version;
        }

        @Generated
        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Generated
        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Generated
        public void setExpirationDate(ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
        }
    }
}

