/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.hibernate.LockOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="ticketTransactionManager")
public class JpaTicketRegistry
extends AbstractTicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaTicketRegistry.class);
    private static final int STREAM_BATCH_SIZE = 100;
    private final TicketCatalog ticketCatalog;
    private final LockModeType lockType;
    @PersistenceContext(unitName="ticketEntityManagerFactory")
    private transient EntityManager entityManager;

    public JpaTicketRegistry(LockModeType lockType, TicketCatalog ticketCatalog) {
        this.lockType = lockType;
        this.ticketCatalog = ticketCatalog;
    }

    public Ticket updateTicket(Ticket ticket) {
        this.entityManager.merge((Object)ticket);
        LOGGER.debug("Updated ticket [{}].", (Object)ticket);
        return ticket;
    }

    public void addTicket(Ticket ticket) {
        this.entityManager.persist((Object)ticket);
        LOGGER.debug("Added ticket [{}] to registry.", (Object)ticket);
    }

    public long deleteAll() {
        return this.ticketCatalog.findAll().stream().map(JpaTicketRegistry::getTicketEntityName).map(entityName -> this.entityManager.createQuery(String.format("delete from %s", entityName))).mapToLong(Query::executeUpdate).sum();
    }

    public Ticket getTicket(String ticketId) {
        try {
            TicketDefinition tkt = this.ticketCatalog.find(ticketId);
            String sql = String.format("select t from %s t where t.id = :id", JpaTicketRegistry.getTicketEntityName(tkt));
            TypedQuery query = this.entityManager.createQuery(sql, tkt.getImplementationClass());
            query.setParameter("id", (Object)ticketId);
            query.setLockMode(this.lockType);
            Ticket result = (Ticket)query.getSingleResult();
            if (result != null && result.isExpired()) {
                LOGGER.debug("Ticket [{}] has expired and will be removed from the database", (Object)result.getId());
                return null;
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error getting ticket [{}] from registry.", (Object)ticketId, (Object)e);
            return null;
        }
    }

    public Collection<Ticket> getTickets() {
        return this.ticketCatalog.findAll().stream().map(t -> {
            String sql = String.format("select t from %s t", JpaTicketRegistry.getTicketEntityName(t));
            TypedQuery query = this.entityManager.createQuery(sql, t.getImplementationClass());
            query.setLockMode(this.lockType);
            return query;
        }).map(TypedQuery::getResultList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Stream<Ticket> getTicketsStream() {
        return this.ticketCatalog.findAll().stream().map(t -> {
            String sql = String.format("select t from %s t", JpaTicketRegistry.getTicketEntityName(t));
            org.hibernate.query.Query query = (org.hibernate.query.Query)this.entityManager.createQuery(sql, t.getImplementationClass());
            query.setFetchSize(100);
            query.setLockOptions(LockOptions.NONE);
            return query;
        }).flatMap(org.hibernate.query.Query::stream);
    }

    public long sessionCount() {
        TicketDefinition md = this.ticketCatalog.find("TGT");
        String sql = String.format("select count(t) from %s t", JpaTicketRegistry.getTicketEntityName(md));
        Query query = this.entityManager.createQuery(sql);
        return JpaTicketRegistry.countToLong(query.getSingleResult());
    }

    public long serviceTicketCount() {
        TicketDefinition md = this.ticketCatalog.find("ST");
        String sql = String.format("select count(t) from %s t", JpaTicketRegistry.getTicketEntityName(md));
        Query query = this.entityManager.createQuery(sql);
        return JpaTicketRegistry.countToLong(query.getSingleResult());
    }

    public boolean deleteSingleTicket(String ticketId) {
        int totalCount = 0;
        TicketDefinition md = this.ticketCatalog.find(ticketId);
        if (md.getProperties().isCascade()) {
            totalCount = this.deleteTicketGrantingTickets(ticketId);
        } else {
            String ticketEntityName = JpaTicketRegistry.getTicketEntityName(md);
            try {
                String sql = String.format("delete from %s o where o.id = :id", ticketEntityName);
                Query query = this.entityManager.createQuery(sql);
                query.setParameter("id", (Object)ticketId);
                totalCount = query.executeUpdate();
            }
            catch (EntityNotFoundException e) {
                LOGGER.debug("Entity [{}] for ticket id [{}] is not found in the database and may have already been deleted", (Object)ticketEntityName, (Object)ticketId);
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        return totalCount != 0;
    }

    private static String getTicketEntityName(TicketDefinition tk) {
        return tk.getImplementationClass().getSimpleName();
    }

    private int deleteTicketGrantingTickets(String ticketId) {
        int totalCount = 0;
        TicketDefinition st = this.ticketCatalog.find("ST");
        String sql1 = String.format("delete from %s s where s.ticketGrantingTicket.id = :id", JpaTicketRegistry.getTicketEntityName(st));
        Query query = this.entityManager.createQuery(sql1);
        query.setParameter("id", (Object)ticketId);
        totalCount += query.executeUpdate();
        TicketDefinition tgt = this.ticketCatalog.find("TGT");
        String sql2 = String.format("delete from %s s where s.ticketGrantingTicket.id = :id", JpaTicketRegistry.getTicketEntityName(tgt));
        query = this.entityManager.createQuery(sql2);
        query.setParameter("id", (Object)ticketId);
        totalCount += query.executeUpdate();
        String sql3 = String.format("delete from %s t where t.id = :id", JpaTicketRegistry.getTicketEntityName(tgt));
        query = this.entityManager.createQuery(sql3);
        query.setParameter("id", (Object)ticketId);
        return totalCount += query.executeUpdate();
    }

    private static long countToLong(Object result) {
        return ((Number)result).longValue();
    }
}

