/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.ticket.registry.TicketRegistryProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.model.support.jpa.ticketregistry.JpaTicketRegistryProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.registry.JpaTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.support.JpaLockingStrategy;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.InetAddressUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@org.springframework.context.annotation.Configuration(value="jpaTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class JpaTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaTicketRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public List<String> ticketPackagesToScan() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)CentralAuthenticationService.NAMESPACE, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        Set subTypes = reflections.getSubTypesOf(AbstractTicket.class);
        List<String> packages = subTypes.stream().map(t -> t.getPackage().getName()).collect(Collectors.toList());
        return packages;
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean ticketEntityManagerFactory() {
        return JpaBeans.newHibernateEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)JpaBeans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc()), "jpaTicketRegistryContext", this.ticketPackagesToScan(), this.dataSourceTicket()), (AbstractJpaProperties)this.casProperties.getTicket().getRegistry().getJpa());
    }

    @Bean
    public PlatformTransactionManager ticketTransactionManager(@Qualifier(value="ticketEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @Bean
    @ConditionalOnMissingBean(name={"dataSourceTicket"})
    public DataSource dataSourceTicket() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getTicket().getRegistry().getJpa());
    }

    @Autowired
    @Bean
    @RefreshScope
    public TicketRegistry ticketRegistry(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        JpaTicketRegistryProperties jpa = this.casProperties.getTicket().getRegistry().getJpa();
        JpaTicketRegistry bean = new JpaTicketRegistry(jpa.getTicketLockType(), ticketCatalog);
        bean.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)jpa.getCrypto(), (String)"jpa"));
        return bean;
    }

    @Bean
    public LockingStrategy lockingStrategy() {
        TicketRegistryProperties registry = this.casProperties.getTicket().getRegistry();
        String uniqueId = (String)StringUtils.defaultIfEmpty((CharSequence)this.casProperties.getHost().getName(), (CharSequence)InetAddressUtils.getCasServerHostName());
        return new JpaLockingStrategy("cas-ticket-registry-cleaner", uniqueId, Beans.newDuration((String)registry.getJpa().getJpaLockingTimeout()).getSeconds());
    }
}

