/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="transactionManagerServiceReg")
public class JpaServiceRegistry
extends AbstractServiceRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaServiceRegistry.class);
    private static final String ENTITY_NAME = AbstractRegisteredService.class.getSimpleName();
    @PersistenceContext(unitName="serviceEntityManagerFactory")
    private transient EntityManager entityManager;

    public boolean delete(RegisteredService registeredService) {
        if (this.entityManager.contains((Object)registeredService)) {
            this.entityManager.remove((Object)registeredService);
        } else {
            this.entityManager.remove(this.entityManager.merge((Object)registeredService));
        }
        return true;
    }

    public List<RegisteredService> load() {
        String query = String.format("select r from %s r", ENTITY_NAME);
        List list = this.entityManager.createQuery(query, RegisteredService.class).getResultList();
        list.forEach(s -> this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, s)));
        return list;
    }

    public RegisteredService save(RegisteredService registeredService) {
        boolean isNew = registeredService.getId() == -1L;
        RegisteredService r = (RegisteredService)this.entityManager.merge((Object)registeredService);
        if (!isNew) {
            this.entityManager.persist((Object)r);
        }
        return r;
    }

    public RegisteredService findServiceById(long id) {
        return (RegisteredService)this.entityManager.find(AbstractRegisteredService.class, (Object)id);
    }

    public RegisteredService findServiceById(String id) {
        return this.load().stream().filter(r -> r.matches(id)).findFirst().orElse(null);
    }

    public long size() {
        String query = String.format("select count(r) from %s r", ENTITY_NAME);
        return (Long)this.entityManager.createQuery(query, Long.class).getSingleResult();
    }

    @Generated
    public String toString() {
        return "JpaServiceRegistry(entityManager=" + this.entityManager + ")";
    }
}

