/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc.config;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.BindModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.BaseJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.BindJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryEncodeJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.SearchJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasJdbcAuthenticationConfiguration", proxyBeanMethods=false)
public class CasJdbcAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasJdbcAuthenticationConfiguration.class);

    private static AuthenticationHandler searchModeSearchDatabaseAuthenticationHandler(SearchJdbcAuthenticationProperties b, PasswordPolicyContext config, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager) {
        SearchModeSearchDatabaseAuthenticationHandler h = new SearchModeSearchDatabaseAuthenticationHandler(b, servicesManager, jdbcPrincipalFactory, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)b));
        CasJdbcAuthenticationConfiguration.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, config, (BaseJdbcAuthenticationProperties)b, applicationContext);
        return h;
    }

    private static void configureJdbcAuthenticationHandler(AbstractJdbcUsernamePasswordAuthenticationHandler handler, PasswordPolicyContext config, BaseJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext) {
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)properties.getPasswordEncoder(), (ApplicationContext)applicationContext));
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)properties.getPrincipalTransformation()));
        handler.setPasswordPolicyConfiguration(config);
        handler.setState(properties.getState());
        if (StringUtils.isNotBlank((CharSequence)properties.getCredentialCriteria())) {
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)properties.getCredentialCriteria()));
        }
        LOGGER.trace("Configured authentication handler [{}] to handle database url at [{}]", (Object)handler.getName(), (Object)properties.getName());
    }

    private static AuthenticationHandler queryAndEncodeDatabaseAuthenticationHandler(QueryEncodeJdbcAuthenticationProperties b, PasswordPolicyContext config, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager) {
        QueryAndEncodeDatabaseAuthenticationHandler h = new QueryAndEncodeDatabaseAuthenticationHandler(b, servicesManager, jdbcPrincipalFactory, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)b));
        CasJdbcAuthenticationConfiguration.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, config, (BaseJdbcAuthenticationProperties)b, applicationContext);
        return h;
    }

    private static AuthenticationHandler queryDatabaseAuthenticationHandler(QueryJdbcAuthenticationProperties b, PasswordPolicyContext config, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager) {
        Multimap attributes = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)b.getPrincipalAttributeList());
        LOGGER.trace("Created and mapped principal attributes [{}] for [{}]...", (Object)attributes, (Object)b.getName());
        QueryDatabaseAuthenticationHandler h = new QueryDatabaseAuthenticationHandler(b, servicesManager, jdbcPrincipalFactory, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)b), CollectionUtils.wrap((Multimap)attributes));
        CasJdbcAuthenticationConfiguration.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, config, (BaseJdbcAuthenticationProperties)b, applicationContext);
        return h;
    }

    private static AuthenticationHandler bindModeSearchDatabaseAuthenticationHandler(BindJdbcAuthenticationProperties b, PasswordPolicyContext config, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager) {
        BindModeSearchDatabaseAuthenticationHandler h = new BindModeSearchDatabaseAuthenticationHandler(b.getName(), servicesManager, jdbcPrincipalFactory, Integer.valueOf(b.getOrder()), (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)b));
        CasJdbcAuthenticationConfiguration.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, config, (BaseJdbcAuthenticationProperties)b, applicationContext);
        return h;
    }

    @ConditionalOnMissingBean(name={"jdbcAuthenticationHandlers"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Collection<AuthenticationHandler> jdbcAuthenticationHandlers(@Qualifier(value="queryPasswordPolicyConfiguration") PasswordPolicyContext queryPasswordPolicyConfiguration, @Qualifier(value="searchModePasswordPolicyConfiguration") PasswordPolicyContext searchModePasswordPolicyConfiguration, @Qualifier(value="bindSearchPasswordPolicyConfiguration") PasswordPolicyContext bindSearchPasswordPolicyConfiguration, @Qualifier(value="queryAndEncodePasswordPolicyConfiguration") PasswordPolicyContext queryAndEncodePasswordPolicyConfiguration, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="jdbcPrincipalFactory") PrincipalFactory jdbcPrincipalFactory, CasConfigurationProperties casProperties) {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        JdbcAuthenticationProperties jdbc = casProperties.getAuthn().getJdbc();
        jdbc.getBind().forEach(b -> handlers.add(CasJdbcAuthenticationConfiguration.bindModeSearchDatabaseAuthenticationHandler(b, bindSearchPasswordPolicyConfiguration, applicationContext, jdbcPrincipalFactory, servicesManager)));
        jdbc.getEncode().forEach(b -> handlers.add(CasJdbcAuthenticationConfiguration.queryAndEncodeDatabaseAuthenticationHandler(b, queryAndEncodePasswordPolicyConfiguration, applicationContext, jdbcPrincipalFactory, servicesManager)));
        jdbc.getQuery().forEach(b -> handlers.add(CasJdbcAuthenticationConfiguration.queryDatabaseAuthenticationHandler(b, queryPasswordPolicyConfiguration, applicationContext, jdbcPrincipalFactory, servicesManager)));
        jdbc.getSearch().forEach(b -> handlers.add(CasJdbcAuthenticationConfiguration.searchModeSearchDatabaseAuthenticationHandler(b, searchModePasswordPolicyConfiguration, applicationContext, jdbcPrincipalFactory, servicesManager)));
        return handlers;
    }

    @ConditionalOnMissingBean(name={"jdbcPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory jdbcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"queryAndEncodePasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext queryAndEncodePasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"searchModePasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext searchModePasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"queryPasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext queryPasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"bindSearchPasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext bindSearchPasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"jdbcAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer jdbcAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="jdbcAuthenticationHandlers") Collection<AuthenticationHandler> jdbcAuthenticationHandlers, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> jdbcAuthenticationHandlers.forEach(h -> plan.registerAuthenticationHandlerWithPrincipalResolver(h, defaultPrincipalResolver));
    }
}

