/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic.config;

import org.apereo.cas.adaptors.generic.ShiroAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.generic.ShiroAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="shiroAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class ShiroAuthenticationEventExecutionPlanConfiguration
implements AuthenticationEventExecutionPlanConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShiroAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired(required=false)
    @Qualifier(value="shiroPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration shiroPasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"shiroPrincipalFactory"})
    @Bean
    public PrincipalFactory shiroPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler shiroAuthenticationHandler() {
        ShiroAuthenticationProperties shiro = this.casProperties.getAuthn().getShiro();
        ShiroAuthenticationHandler h = new ShiroAuthenticationHandler(shiro.getName(), this.servicesManager, this.shiroPrincipalFactory(), shiro.getRequiredRoles(), shiro.getRequiredPermissions());
        h.loadShiroConfiguration(shiro.getConfig().getLocation());
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)shiro.getPasswordEncoder()));
        if (this.shiroPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.shiroPasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)shiro.getPrincipalTransformation()));
        return h;
    }

    public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
        if (this.casProperties.getAuthn().getShiro().getConfig().getLocation() != null) {
            LOGGER.debug("Injecting shiro authentication handler");
            plan.registerAuthenticationHandlerWithPrincipalResolver(this.shiroAuthenticationHandler(), this.personDirectoryPrincipalResolver);
        }
    }
}

