/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic.config;

import java.util.Set;
import org.apereo.cas.adaptors.generic.RejectUsersAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.generic.RejectAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="rejectUsersAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RejectUsersAuthenticationEventExecutionPlanConfiguration
implements AuthenticationEventExecutionPlanConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejectUsersAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired(required=false)
    @Qualifier(value="rejectPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration rejectPasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;

    @ConditionalOnMissingBean(name={"rejectPrincipalFactory"})
    @Bean
    public PrincipalFactory rejectUsersPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler rejectUsersAuthenticationHandler() {
        RejectAuthenticationProperties rejectProperties = this.casProperties.getAuthn().getReject();
        Set users = StringUtils.commaDelimitedListToSet((String)rejectProperties.getUsers());
        RejectUsersAuthenticationHandler h = new RejectUsersAuthenticationHandler(rejectProperties.getName(), this.servicesManager, this.rejectUsersPrincipalFactory(), users);
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)rejectProperties.getPasswordEncoder()));
        if (this.rejectPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.rejectPasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)rejectProperties.getPrincipalTransformation()));
        return h;
    }

    public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getReject().getUsers())) {
            LOGGER.debug("Added rejecting authentication handler");
            plan.registerAuthenticationHandlerWithPrincipalResolver(this.rejectUsersAuthenticationHandler(), this.personDirectoryPrincipalResolver);
        }
    }
}

