/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic.config;

import org.apereo.cas.adaptors.generic.FileAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.generic.FileAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="fileAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class FileAuthenticationEventExecutionPlanConfiguration
implements AuthenticationEventExecutionPlanConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired(required=false)
    @Qualifier(value="filePasswordPolicyConfiguration")
    private PasswordPolicyConfiguration filePasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;

    @ConditionalOnMissingBean(name={"filePrincipalFactory"})
    @Bean
    public PrincipalFactory filePrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler fileAuthenticationHandler() {
        FileAuthenticationProperties fileProperties = this.casProperties.getAuthn().getFile();
        FileAuthenticationHandler h = new FileAuthenticationHandler(fileProperties.getName(), this.servicesManager, this.filePrincipalFactory(), fileProperties.getFilename(), fileProperties.getSeparator());
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)fileProperties.getPasswordEncoder()));
        if (this.filePasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.filePasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)fileProperties.getPrincipalTransformation()));
        return h;
    }

    public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
        if (this.casProperties.getAuthn().getFile().getFilename() != null) {
            LOGGER.debug("Added file-based authentication handler");
            plan.registerAuthenticationHandlerWithPrincipalResolver(this.fileAuthenticationHandler(), this.personDirectoryPrincipalResolver);
        }
    }
}

