/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic;

import com.google.common.base.Throwables;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.RememberMeUsernamePasswordCredential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ShiroAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShiroAuthenticationHandler.class);
    private final Set<String> requiredRoles;
    private final Set<String> requiredPermissions;

    public ShiroAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Set<String> requiredRoles, Set<String> requiredPermissions) {
        super(name, servicesManager, principalFactory, null);
        this.requiredRoles = requiredRoles;
        this.requiredPermissions = requiredPermissions;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws GeneralSecurityException, PreventedException {
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(transformedCredential.getUsername(), transformedCredential.getPassword());
            if (transformedCredential instanceof RememberMeUsernamePasswordCredential) {
                token.setRememberMe(((RememberMeUsernamePasswordCredential)RememberMeUsernamePasswordCredential.class.cast(transformedCredential)).isRememberMe());
            }
            Subject currentUser = this.getCurrentExecutingSubject();
            currentUser.login((AuthenticationToken)token);
            this.checkSubjectRolesAndPermissions(currentUser);
            return this.createAuthenticatedSubjectResult((Credential)transformedCredential, currentUser);
        }
        catch (UnknownAccountException uae) {
            throw new AccountNotFoundException(uae.getMessage());
        }
        catch (IncorrectCredentialsException ice) {
            throw new FailedLoginException(ice.getMessage());
        }
        catch (ExcessiveAttemptsException | LockedAccountException lae) {
            throw new AccountLockedException(lae.getMessage());
        }
        catch (ExpiredCredentialsException eae) {
            throw new CredentialExpiredException(eae.getMessage());
        }
        catch (DisabledAccountException eae) {
            throw new AccountDisabledException(eae.getMessage());
        }
        catch (AuthenticationException e) {
            throw new FailedLoginException(e.getMessage());
        }
    }

    protected void checkSubjectRolesAndPermissions(Subject currentUser) throws FailedLoginException {
        if (this.requiredRoles != null) {
            for (String role : this.requiredRoles) {
                if (currentUser.hasRole(role)) continue;
                throw new FailedLoginException("Required role " + role + " does not exist");
            }
        }
        if (this.requiredPermissions != null) {
            for (String perm : this.requiredPermissions) {
                if (currentUser.isPermitted(perm)) continue;
                throw new FailedLoginException("Required permission " + perm + " cannot be located");
            }
        }
    }

    protected HandlerResult createAuthenticatedSubjectResult(Credential credential, Subject currentUser) {
        String username = currentUser.getPrincipal().toString();
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), null);
    }

    protected Subject getCurrentExecutingSubject() {
        return SecurityUtils.getSubject();
    }

    public void loadShiroConfiguration(Resource resource) {
        try {
            Resource shiroResource = ResourceUtils.prepareClasspathResourceIfNeeded((Resource)resource);
            if (shiroResource != null && shiroResource.exists()) {
                String location = shiroResource.getURI().toString();
                LOGGER.debug("Loading Shiro configuration from [{}]", (Object)location);
                IniSecurityManagerFactory factory = new IniSecurityManagerFactory(location);
                SecurityManager securityManager = (SecurityManager)factory.getInstance();
                SecurityUtils.setSecurityManager((SecurityManager)securityManager);
            } else {
                LOGGER.debug("Shiro configuration is not defined");
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

