/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic;

import java.security.GeneralSecurityException;
import java.util.Set;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;

public class RejectUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private final Set<String> users;

    public RejectUsersAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Set<String> rejectedUsers) {
        super(name, servicesManager, principalFactory, null);
        this.users = rejectedUsers;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        if (this.users.contains(username)) {
            throw new FailedLoginException();
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
    }
}

