/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.core.io.Resource;

public class FileAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    public static final String DEFAULT_SEPARATOR = "::";
    private final String separator;
    private final Resource fileName;

    public FileAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Resource fileName, String separator) {
        super(name, servicesManager, principalFactory, null);
        this.fileName = fileName;
        this.separator = separator;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws GeneralSecurityException, PreventedException {
        try {
            if (this.fileName == null) {
                throw new FileNotFoundException("Filename does not exist");
            }
            String username = transformedCredential.getUsername();
            String passwordOnRecord = this.getPasswordOnRecord(username);
            if (StringUtils.isBlank((CharSequence)passwordOnRecord)) {
                throw new AccountNotFoundException(username + " not found in backing file.");
            }
            if (this.matches(originalPassword, passwordOnRecord)) {
                return this.createHandlerResult((Credential)transformedCredential, this.principalFactory.createPrincipal(username), null);
            }
        }
        catch (IOException e) {
            throw new PreventedException("IO error reading backing file", (Throwable)e);
        }
        throw new FailedLoginException();
    }

    private String getPasswordOnRecord(String username) throws IOException {
        return Files.lines(this.fileName.getFile().toPath()).map(line -> line.split(this.separator)).filter(lineFields -> {
            String userOnRecord = lineFields[0];
            return username.equals(userOnRecord);
        }).map(lineFields -> lineFields[1]).findFirst().orElse(null);
    }
}

