/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TicketGrantingTicketCheckAction
extends AbstractAction {
    public static final String NOT_EXISTS = "notExists";
    public static final String INVALID = "invalid";
    public static final String VALID = "valid";
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketCheckAction.class);
    private CentralAuthenticationService centralAuthenticationService;

    public TicketGrantingTicketCheckAction() {
    }

    public TicketGrantingTicketCheckAction(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected Event doExecute(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (!StringUtils.hasText((String)tgtId)) {
            return new Event((Object)this, NOT_EXISTS);
        }
        String eventId = INVALID;
        try {
            Ticket ticket = this.centralAuthenticationService.getTicket(tgtId, Ticket.class);
            if (ticket != null && !ticket.isExpired()) {
                eventId = VALID;
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.trace("Could not retrieve ticket id [{}] from registry.", (Object)e.getMessage());
        }
        return new Event((Object)this, eventId);
    }
}

