/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.logout.LogoutHttpMessage;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.web.flow.AbstractLogoutAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FrontChannelLogoutAction
extends AbstractLogoutAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontChannelLogoutAction.class);
    private final LogoutManager logoutManager;

    public FrontChannelLogoutAction(LogoutManager logoutManager) {
        this.logoutManager = logoutManager;
    }

    @Override
    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) {
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)context);
        HashMap logoutUrls = new HashMap();
        if (logoutRequests != null) {
            logoutRequests.stream().filter(r -> r.getStatus() == LogoutRequestStatus.NOT_ATTEMPTED).forEach(r -> {
                LOGGER.debug("Using logout url [{}] for front-channel logout requests", (Object)r.getLogoutUrl().toExternalForm());
                String logoutMessage = this.logoutManager.createFrontChannelLogoutMessage(r);
                LOGGER.debug("Front-channel logout message to send is [{}]", (Object)logoutMessage);
                LogoutHttpMessage msg = new LogoutHttpMessage(r.getLogoutUrl(), logoutMessage, true);
                logoutUrls.put(r, msg);
                r.setStatus(LogoutRequestStatus.SUCCESS);
                r.getService().setLoggedOutAlready(true);
            });
            if (!logoutUrls.isEmpty()) {
                context.getFlowScope().put("logoutUrls", logoutUrls);
                return new EventFactorySupport().event((Object)this, "propagate");
            }
        }
        return new EventFactorySupport().event((Object)this, "finish");
    }
}

