/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.impl.AbstractTranslator;

public abstract class ExternalTranslator
extends AbstractTranslator {
    public Reader runAndGetOutput(String command, String[] env, File workingDirectory) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(command, env, workingDirectory);
        InputStreamReader reader = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
        BufferedReader bufferedReader = new BufferedReader(reader);
        process.waitFor();
        return bufferedReader;
    }

    public boolean checkCommand(String checkCommandString, int ... successCodes) {
        try {
            Process process = Runtime.getRuntime().exec(checkCommandString);
            process.waitFor();
            int result = process.waitFor();
            for (int code : successCodes) {
                if (code != result) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            System.err.println("Broken pipe");
            return false;
        }
        catch (InterruptedException ie) {
            System.err.println("Interrupted");
            return false;
        }
    }

    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        String sourceLanguage = this.detectLanguage(text).getLanguage();
        return this.translate(text, sourceLanguage, targetLanguage);
    }
}

