/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import thredds.inventory.DatasetCollectionManager;
import thredds.inventory.MFile;
import ucar.nc2.units.DateRange;

public class TimedCollection {
    private static final boolean debug = false;
    private final DatasetCollectionManager manager;
    private List<Dataset> datasets;
    private DateRange dateRange;

    public TimedCollection(DatasetCollectionManager manager, Formatter errlog) throws IOException {
        this.manager = manager;
        manager.scan(null);
        this.update();
    }

    public void update() {
        List<MFile> fileList = this.manager.getFiles();
        this.datasets = new ArrayList<Dataset>(fileList.size());
        for (MFile f : fileList) {
            this.datasets.add(new Dataset(f));
        }
        if (this.manager.hasDateExtractor()) {
            if (this.datasets.size() == 1) {
                Dataset ds = this.datasets.get(0);
                if (ds.start != null) {
                    this.dateRange = new DateRange(ds.start, ds.start);
                }
            } else if (this.datasets.size() > 1) {
                for (int i = 0; i < this.datasets.size() - 1; ++i) {
                    Dataset d1 = this.datasets.get(i);
                    Dataset d2 = this.datasets.get(i + 1);
                    d1.setDateRange(new DateRange(d1.start, d2.start));
                    if (i != this.datasets.size() - 2) continue;
                    d2.setDateRange(new DateRange(d2.start, d1.getDateRange().getDuration()));
                }
                Dataset first = this.datasets.get(0);
                Dataset last = this.datasets.get(this.datasets.size() - 1);
                this.dateRange = new DateRange(first.getDateRange().getStart().getDate(), last.getDateRange().getEnd().getDate());
            }
        }
    }

    private TimedCollection(TimedCollection from, DateRange want) {
        this.manager = from.manager;
        this.datasets = new ArrayList<Dataset>(from.datasets.size());
        for (Dataset d : from.datasets) {
            if (!want.intersects(d.getDateRange())) continue;
            this.datasets.add(d);
        }
        this.dateRange = want;
    }

    public Dataset getPrototype() {
        int idx = this.manager.getProtoIndex();
        return this.datasets.get(idx);
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public TimedCollection subset(DateRange range) {
        return new TimedCollection(this, range);
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CollectionManager{%n", new Object[0]);
        for (Dataset d : this.datasets) {
            f.format(" %s%n", d);
        }
        f.format("}%n", new Object[0]);
        return f.toString();
    }

    private static void doit(String spec, Formatter errlog) throws IOException {
        DatasetCollectionManager dcm = DatasetCollectionManager.open(spec, null, errlog);
        TimedCollection specp = new TimedCollection(dcm, errlog);
        System.out.printf("spec= %s%n%s%n", spec, specp);
        String err = errlog.toString();
        if (err.length() > 0) {
            System.out.printf("%s%n", err);
        }
        System.out.printf("-----------------------------------%n", new Object[0]);
    }

    public static void main(String[] arg) throws IOException {
        TimedCollection.doit("C:/data/formats/gempak/surface/#yyyyMMdd#_sao.gem", new Formatter());
    }

    public class Dataset {
        String location;
        DateRange dateRange;
        Date start;

        Dataset(MFile f) {
            this.location = f.getPath();
            this.start = TimedCollection.this.manager.extractRunDate(f);
        }

        public String getLocation() {
            return this.location;
        }

        public DateRange getDateRange() {
            return this.dateRange;
        }

        public void setDateRange(DateRange dateRange) {
            this.dateRange = dateRange;
        }

        public String toString() {
            return "Dataset{location='" + this.location + '\'' + ", dateRange=" + this.dateRange + '}';
        }
    }
}

