/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ucar.nc2.util.IO;

public class XMLEntityResolver
implements EntityResolver {
    private static boolean debugEntityResolution = false;
    private static Map<String, String> entityHash = new HashMap<String, String>();
    private static boolean schemaValidationOk = true;
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String CATALOG_NAMESPACE_06 = "http://www.unidata.ucar.edu/thredds";
    public static final String CATALOG_NAMESPACE_10 = "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0";
    public static final String DQC_NAMESPACE_02 = "http://www.unidata.ucar.edu/schemas/thredds/queryCapability";
    public static final String DQC_NAMESPACE_03 = "http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.3";
    public static final String DQC_NAMESPACE_04 = "http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4";
    public static final String CATGEN_NAMESPACE_05 = "http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5";
    public static final String NJ22_NAMESPACE = "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2";
    public static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    public static final Namespace xlinkNS = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    public static final Namespace xsiNS = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static boolean hasXerces;
    private static String externalSchemas;
    private SAXBuilder saxBuilder;
    private StringBuilder warnMessages = new StringBuilder();
    private StringBuilder errMessages = new StringBuilder();
    private StringBuilder fatalMessages = new StringBuilder();

    public static String getExternalSchemas() {
        if (externalSchemas == null) {
            externalSchemas = "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0 http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.0.3.xsd http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2 http://www.unidata.ucar.edu/schemas/netcdf/ncml-2.2.xsd http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4 http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.4.xsd http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.3 http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.3.xsd http://www.unidata.ucar.edu/schemas/thredds/queryCapability http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.2.xsd http://www.unidata.ucar.edu/thredds http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.0.6.xsd";
        }
        return externalSchemas;
    }

    public static void initEntity(String entityName, String resourceName, String urlName) {
        String entity = null;
        try {
            ByteArrayOutputStream sbuff = new ByteArrayOutputStream(3000);
            InputStream is = IO.getFileResource(resourceName);
            if (is != null) {
                IO.copy(is, sbuff);
                entity = sbuff.toString();
                if (debugEntityResolution) {
                    System.out.println(" *** entity " + entityName + " mapped to local resource at " + resourceName);
                }
            } else if (urlName != null) {
                entity = IO.readURLcontentsWithException(urlName);
                if (debugEntityResolution) {
                    System.out.println(" *** entity " + entityName + " mapped to remote URL at " + urlName);
                }
            }
        }
        catch (IOException e) {
            System.out.println(" *** FAILED to map entity " + entityName + " locally at " + resourceName + " or remotely at " + urlName);
        }
        entityHash.put(entityName, entity);
        entityHash.put(urlName, entity);
    }

    public static String getDocumentBuilderFactoryVersion() {
        try {
            Class<?> version = Class.forName("org.apache.xerces.impl.Version");
            Method m = version.getMethod("getVersion", null);
            return (String)m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return "Error= " + e.getMessage();
        }
    }

    private static void showFactoryInfo(DocumentBuilderFactory factory) {
        System.out.println("------------------------");
        System.out.println("DocumentBuilderFactory class= " + factory.getClass().getName());
        try {
            Class<?> version = Class.forName("org.apache.xerces.impl.Version");
            Method m = version.getMethod("getVersion", null);
            System.out.println(" org.apache.xerces.impl.Version.version()=" + m.invoke(null, (Object[])null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(" factory.isValidating()=" + factory.isValidating());
        System.out.println(" factory.isNamespaceAware()=" + factory.isNamespaceAware());
        System.out.println(" factory.isIgnoringElementContentWhitespace()=" + factory.isIgnoringElementContentWhitespace());
        System.out.println(" factory.isExpandEntityReferences()=" + factory.isExpandEntityReferences());
        System.out.println(" factory.isIgnoringComments()=" + factory.isIgnoringComments());
        System.out.println(" factory.isCoalescing()=" + factory.isCoalescing());
    }

    private static void showBuilderInfo(DocumentBuilder builder) {
        System.out.println("-----------------------");
        System.out.println(" builder.isValidating()=" + builder.isValidating());
        System.out.println(" builder.isNamespaceAware()=" + builder.isNamespaceAware());
        System.out.println("DocumentBuilder class= " + builder.getClass().getName());
    }

    public XMLEntityResolver(boolean validate) {
        this.saxBuilder = hasXerces ? new SAXBuilder(validate) : new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        this.saxBuilder.setErrorHandler(new MyErrorHandler());
        if (validate) {
            this.saxBuilder.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.saxBuilder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", XMLEntityResolver.getExternalSchemas());
        }
        this.saxBuilder.setEntityResolver(this);
    }

    public SAXBuilder getSAXBuilder() {
        return this.saxBuilder;
    }

    public StringBuilder getWarningMessages() {
        return this.warnMessages;
    }

    public StringBuilder getErrorMessages() {
        return this.errMessages;
    }

    public StringBuilder getFatalMessages() {
        return this.fatalMessages;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String entity;
        if (debugEntityResolution) {
            System.out.print("  publicId=" + publicId + " systemId=" + systemId);
        }
        if ((entity = entityHash.get(systemId)) != null) {
            if (debugEntityResolution) {
                System.out.println(" *** resolved  with local copy");
            }
            return new MyInputSource(entity);
        }
        if (systemId.indexOf("InvCatalog.0.6.dtd") >= 0 && (entity = entityHash.get("http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd")) != null) {
            if (debugEntityResolution) {
                System.out.println(" *** resolved2 with local copy");
            }
            return new MyInputSource(entity);
        }
        if (debugEntityResolution) {
            System.out.println(" *** not resolved");
        }
        return null;
    }

    static {
        XMLEntityResolver.initEntity("http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd", "/resources/thredds/schemas/InvCatalog.0.6.dtd", "http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd");
        XMLEntityResolver.initEntity(CATALOG_NAMESPACE_10, "/resources/thredds/schemas/InvCatalog.1.0.3.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.0.3.xsd");
        XMLEntityResolver.initEntity(CATALOG_NAMESPACE_06, "/resources/thredds/schemas/InvCatalog.0.6.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.0.6.xsd");
        XMLEntityResolver.initEntity(DQC_NAMESPACE_02, "/resources/thredds/schemas/queryCapability.0.2.xsd", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.2.xsd");
        XMLEntityResolver.initEntity(DQC_NAMESPACE_03, "/resources/thredds/schemas/queryCapability.0.3.xsd", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.3.xsd");
        XMLEntityResolver.initEntity(DQC_NAMESPACE_04, "/resources/thredds/schemas/queryCapability.0.4.xsd", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.4.xsd");
        XMLEntityResolver.initEntity(NJ22_NAMESPACE, "/resources/nj22/schemas/ncml-2.2.xsd", "http://www.unidata.ucar.edu/schemas/netcdf/ncml-2.2.xsd");
        XMLEntityResolver.initEntity(XLINK_NAMESPACE, "/resources/thredds/schemas/xlink.xsd", "http://www.unidata.ucar.edu/schemas/other/xlink.xsd");
        XMLEntityResolver.initEntity("http://www.unidata.ucar.edu/projects/THREDDS/xml/CatalogGenConfig.0.5.dtd", "/resources/thredds/schemas/CatalogGenConfig.0.5.dtd", "http://www.unidata.ucar.edu/projects/THREDDS/xml/CatalogGenConfig.0.5.dtd");
        String javaVersion = System.getProperty("java.version").substring(2, 3);
        int v = Integer.parseInt(javaVersion);
        hasXerces = v >= 5;
        hasXerces = true;
    }

    private class MyInputSource
    extends InputSource {
        MyInputSource(String entity) {
            this.setCharacterStream(new StringReader(entity));
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            XMLEntityResolver.this.warnMessages.append("*** XML parser warning ").append(this.showError(e)).append("\n");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            XMLEntityResolver.this.errMessages.append("*** XML parser error ").append(this.showError(e)).append("\n");
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            XMLEntityResolver.this.fatalMessages.append("*** XML parser fatalError ").append(this.showError(e)).append("\n");
        }

        private String showError(SAXParseException e) {
            return "(" + e.getLineNumber() + ":" + e.getColumnNumber() + ")= " + e.getMessage();
        }
    }
}

