/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@Provider
@Produces(value={"application/x-tar"})
public class TarWriter
implements MessageBodyWriter<Map<String, byte[]>> {
    private static void tarStoreBuffer(TarArchiveOutputStream zip, String name, byte[] dataBuffer) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize(dataBuffer.length);
        zip.putArchiveEntry(entry);
        zip.write(dataBuffer);
        zip.closeArchiveEntry();
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Map.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Map<String, byte[]> stringMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Map<String, byte[]> parts, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        TarArchiveOutputStream zip = new TarArchiveOutputStream(entityStream);
        for (Map.Entry<String, byte[]> entry : parts.entrySet()) {
            TarWriter.tarStoreBuffer(zip, entry.getKey(), entry.getValue());
        }
        zip.close();
    }
}

