/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.server.MetadataList;
import org.apache.tika.server.TikaResource;
import org.xml.sax.helpers.DefaultHandler;

@Path(value="/rmeta")
public class RecursiveMetadataResource {
    private static final Log logger = LogFactory.getLog(RecursiveMetadataResource.class);
    private TikaConfig tikaConfig;

    public RecursiveMetadataResource(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/csv", "application/json"})
    @Path(value="form")
    public Response getMetadataFromMultipart(Attachment att, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(att.getObject(InputStream.class), att.getHeaders(), info)).build();
    }

    @PUT
    @Produces(value={"application/json"})
    public Response getMetadata(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(is, httpHeaders.getRequestHeaders(), info)).build();
    }

    private MetadataList parseMetadata(InputStream is, MultivaluedMap<String, String> httpHeaders, UriInfo info) throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        AutoDetectParser parser = TikaResource.createParser(this.tikaConfig);
        BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.HANDLER_TYPE.TEXT;
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper(parser, new BasicContentHandlerFactory(type, -1));
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders);
        TikaResource.logRequest(logger, info, metadata);
        wrapper.parse(is, new DefaultHandler(), metadata, context);
        return new MetadataList(wrapper.getMetadata());
    }
}

