/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.server.TikaResource;
import org.xml.sax.helpers.DefaultHandler;

@Path(value="/meta")
public class MetadataResource {
    private static final Log logger = LogFactory.getLog(MetadataResource.class);
    private TikaConfig tikaConfig;

    public MetadataResource(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/csv", "application/json", "application/rdf+xml"})
    @Path(value="form")
    public Response getMetadataFromMultipart(Attachment att, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(att.getObject(InputStream.class), att.getHeaders(), info)).build();
    }

    @PUT
    @Produces(value={"text/csv", "application/json", "application/rdf+xml"})
    public Response getMetadata(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(is, httpHeaders.getRequestHeaders(), info)).build();
    }

    @PUT
    @Path(value="{field}")
    @Produces(value={"text/csv", "application/json", "application/rdf+xml", "text/plain"})
    public Response getMetadataField(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="field") String field) throws Exception {
        Response.Status defaultErrorResponse = Response.Status.BAD_REQUEST;
        Metadata metadata = null;
        try {
            metadata = this.parseMetadata(is, httpHeaders.getRequestHeaders(), info);
            defaultErrorResponse = Response.Status.NOT_FOUND;
        }
        catch (Exception e) {
            logger.info("Failed to process field " + field, e);
        }
        if (metadata == null || metadata.get(field) == null) {
            return Response.status(defaultErrorResponse).entity("Failed to get metadata field " + field).build();
        }
        for (String name : metadata.names()) {
            if (field.equals(name)) continue;
            metadata.remove(name);
        }
        return Response.ok(metadata).build();
    }

    private Metadata parseMetadata(InputStream is, MultivaluedMap<String, String> httpHeaders, UriInfo info) throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        AutoDetectParser parser = TikaResource.createParser(this.tikaConfig);
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders);
        TikaResource.logRequest(logger, info, metadata);
        parser.parse(is, new DefaultHandler(), metadata, context);
        return metadata;
    }
}

