/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.server.TikaResource;

@Path(value="/detect")
public class DetectorResource {
    private static final Log logger = LogFactory.getLog(DetectorResource.class.getName());
    private TikaConfig config = null;

    public DetectorResource(TikaConfig config) {
        this.config = config;
    }

    @PUT
    @Path(value="stream")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String detect(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        Metadata met = new Metadata();
        TikaInputStream tis = TikaInputStream.get(is);
        String filename = TikaResource.detectFilename(httpHeaders.getRequestHeaders());
        logger.info("Detecting media type for Filename: " + filename);
        met.add("resourceName", filename);
        try {
            return this.config.getDetector().detect(tis, met).toString();
        }
        catch (IOException e) {
            logger.warn("Unable to detect MIME type for file. Reason: " + e.getMessage());
            e.printStackTrace();
            return MediaType.OCTET_STREAM.toString();
        }
    }
}

