/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;

public class XSLFGraphicFrame
extends XSLFShape {
    private final CTGraphicalObjectFrame _shape;
    private final XSLFSheet _sheet;

    XSLFGraphicFrame(CTGraphicalObjectFrame shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
    }

    @Override
    public CTGraphicalObjectFrame getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public int getShapeType() {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public int getShapeId() {
        return (int)this._shape.getNvGraphicFramePr().getCNvPr().getId();
    }

    @Override
    public String getShapeName() {
        return this._shape.getNvGraphicFramePr().getCNvPr().getName();
    }

    @Override
    public Rectangle2D getAnchor() {
        CTTransform2D xfrm = this._shape.getXfrm();
        CTPoint2D off = xfrm.getOff();
        long x = off.getX();
        long y = off.getY();
        CTPositiveSize2D ext = xfrm.getExt();
        long cx = ext.getCx();
        long cy = ext.getCy();
        return new Rectangle2D.Double(Units.toPoints(x), Units.toPoints(y), Units.toPoints(cx), Units.toPoints(cy));
    }

    @Override
    public void setAnchor(Rectangle2D anchor) {
        CTTransform2D xfrm = this._shape.getXfrm();
        CTPoint2D off = xfrm.isSetOff() ? xfrm.getOff() : xfrm.addNewOff();
        long x = Units.toEMU(anchor.getX());
        long y = Units.toEMU(anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetExt() ? xfrm.getExt() : xfrm.addNewExt();
        long cx = Units.toEMU(anchor.getWidth());
        long cy = Units.toEMU(anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    static XSLFGraphicFrame create(CTGraphicalObjectFrame shape, XSLFSheet sheet) {
        String uri = shape.getGraphic().getGraphicData().getUri();
        if (XSLFTable.TABLE_URI.equals(uri)) {
            return new XSLFTable(shape, sheet);
        }
        return new XSLFGraphicFrame(shape, sheet);
    }

    @Override
    public void setRotation(double theta) {
        throw new IllegalArgumentException("Operation not supported");
    }

    @Override
    public double getRotation() {
        return 0.0;
    }

    @Override
    public void setFlipHorizontal(boolean flip) {
        throw new IllegalArgumentException("Operation not supported");
    }

    @Override
    public void setFlipVertical(boolean flip) {
        throw new IllegalArgumentException("Operation not supported");
    }

    @Override
    public boolean getFlipHorizontal() {
        return false;
    }

    @Override
    public boolean getFlipVertical() {
        return false;
    }

    @Override
    public void draw(Graphics2D graphics) {
    }

    @Override
    void copy(XSLFShape sh) {
        super.copy(sh);
        CTGraphicalObjectData data = this._shape.getGraphic().getGraphicData();
        String uri = data.getUri();
        if (uri.equals("http://schemas.openxmlformats.org/drawingml/2006/diagram")) {
            this.copyDiagram(data, (XSLFGraphicFrame)sh);
        }
    }

    private void copyDiagram(CTGraphicalObjectData objData, XSLFGraphicFrame srcShape) {
        String xpath = "declare namespace dgm='http://schemas.openxmlformats.org/drawingml/2006/diagram' $this//dgm:relIds";
        XmlObject[] obj = objData.selectPath(xpath);
        if (obj != null && obj.length == 1) {
            XmlCursor c = obj[0].newCursor();
            XSLFSheet sheet = srcShape.getSheet();
            try {
                String dm = c.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "dm"));
                PackageRelationship dmRel = sheet.getPackagePart().getRelationship(dm);
                PackagePart dmPart = sheet.getPackagePart().getRelatedPart(dmRel);
                this._sheet.importPart(dmRel, dmPart);
                String lo = c.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "lo"));
                PackageRelationship loRel = sheet.getPackagePart().getRelationship(lo);
                PackagePart loPart = sheet.getPackagePart().getRelatedPart(loRel);
                this._sheet.importPart(loRel, loPart);
                String qs = c.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "qs"));
                PackageRelationship qsRel = sheet.getPackagePart().getRelationship(qs);
                PackagePart qsPart = sheet.getPackagePart().getRelatedPart(qsRel);
                this._sheet.importPart(qsRel, qsPart);
                String cs = c.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "cs"));
                PackageRelationship csRel = sheet.getPackagePart().getRelationship(cs);
                PackagePart csPart = sheet.getPackagePart().getRelatedPart(csRel);
                this._sheet.importPart(csRel, csPart);
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException(e);
            }
            c.dispose();
        }
    }
}

