/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class OEShapeAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _recdata;

    public OEShapeAtom() {
        this._recdata = new byte[4];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    protected OEShapeAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._recdata = new byte[len - 8];
        System.arraycopy(source, start + 8, this._recdata, 0, len - 8);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.OEShapeAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._recdata);
    }

    public int getOptions() {
        return LittleEndian.getInt(this._recdata, 0);
    }

    public void setOptions(int id) {
        LittleEndian.putInt(this._recdata, 0, id);
    }
}

