/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.ImageParameters;
import org.apache.pdfbox.util.PDFOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFStreamParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFStreamParser.class);
    private List<Object> streamObjects = new ArrayList<Object>(100);
    private final RandomAccess file;
    private final int maxBinCharTestLength = 10;
    private final byte[] binCharTestArr = new byte[10];

    public PDFStreamParser(InputStream stream, RandomAccess raf, boolean forceParsing) throws IOException {
        super(stream, forceParsing);
        this.file = raf;
    }

    public PDFStreamParser(InputStream stream, RandomAccess raf) throws IOException {
        this(stream, raf, FORCE_PARSING);
    }

    public PDFStreamParser(PDStream stream) throws IOException {
        this(stream.createInputStream(), stream.getStream().getScratchFile());
    }

    public PDFStreamParser(COSStream stream, boolean forceParsing) throws IOException {
        this(stream.getUnfilteredStream(), stream.getScratchFile(), forceParsing);
    }

    public PDFStreamParser(COSStream stream) throws IOException {
        this(stream.getUnfilteredStream(), stream.getScratchFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            Object token;
            while ((token = this.parseNextToken()) != null) {
                this.streamObjects.add(token);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.pdfSource.close();
            throw throwable;
        }
        this.pdfSource.close();
    }

    public List<Object> getTokens() {
        return this.streamObjects;
    }

    public void close() throws IOException {
        this.pdfSource.close();
    }

    public Iterator<Object> getTokenIterator() {
        return new Iterator<Object>(){
            private Object token;

            private void tryNext() {
                try {
                    if (this.token == null) {
                        this.token = PDFStreamParser.this.parseNextToken();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.tryNext();
                return this.token != null;
            }

            @Override
            public Object next() {
                this.tryNext();
                Object tmp = this.token;
                if (tmp == null) {
                    throw new NoSuchElementException();
                }
                this.token = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Object parseNextToken() throws IOException {
        Object retval;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        if ((byte)nextByte == -1) {
            return null;
        }
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    COSDictionary pod = this.parseCOSDictionary();
                    this.skipSpaces();
                    if ((char)this.pdfSource.peek() == 's') {
                        retval = this.parseCOSStream(pod, this.file);
                        break;
                    }
                    retval = pod;
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (nullString.equals("null")) {
                    retval = COSNull.NULL;
                    break;
                }
                retval = PDFOperator.getOperator(nullString);
                break;
            }
            case 'f': 
            case 't': {
                String next = this.readString();
                if (next.equals("true")) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                if (next.equals("false")) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                retval = PDFOperator.getOperator(next);
                break;
            }
            case 'R': {
                String line = this.readString();
                if (line.equals("R")) {
                    retval = new COSObject(null);
                    break;
                }
                retval = PDFOperator.getOperator(line);
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean dotNotRead;
                StringBuffer buf = new StringBuffer();
                buf.append(c);
                this.pdfSource.read();
                boolean bl = dotNotRead = c != '.';
                while (Character.isDigit(c = (char)this.pdfSource.peek()) || dotNotRead && c == '.') {
                    buf.append(c);
                    this.pdfSource.read();
                    if (!dotNotRead || c != '.') continue;
                    dotNotRead = false;
                }
                retval = COSNumber.get(buf.toString());
                break;
            }
            case 'B': {
                String next = this.readString();
                retval = PDFOperator.getOperator(next);
                if (!next.equals("BI")) break;
                PDFOperator beginImageOP = (PDFOperator)retval;
                COSDictionary imageParams = new COSDictionary();
                beginImageOP.setImageParameters(new ImageParameters(imageParams));
                Object nextToken = null;
                while ((nextToken = this.parseNextToken()) instanceof COSName) {
                    Object value = this.parseNextToken();
                    imageParams.setItem((COSName)nextToken, (COSBase)value);
                }
                PDFOperator imageData = (PDFOperator)nextToken;
                beginImageOP.setImageData(imageData.getImageData());
                break;
            }
            case 'I': {
                String id = "" + (char)this.pdfSource.read() + (char)this.pdfSource.read();
                if (!id.equals("ID")) {
                    throw new IOException("Error: Expected operator 'ID' actual='" + id + "'");
                }
                ByteArrayOutputStream imageData = new ByteArrayOutputStream();
                if (this.isWhitespace()) {
                    this.pdfSource.read();
                }
                int lastByte = this.pdfSource.read();
                int currentByte = this.pdfSource.read();
                while (!(lastByte == 69 && currentByte == 73 && this.hasNextSpaceOrReturn() && this.hasNoFollowingBinData(this.pdfSource) || this.pdfSource.isEOF())) {
                    imageData.write(lastByte);
                    lastByte = currentByte;
                    currentByte = this.pdfSource.read();
                }
                retval = PDFOperator.getOperator("ID");
                ((PDFOperator)retval).setImageData(imageData.toByteArray());
                break;
            }
            case ']': {
                this.pdfSource.read();
                retval = COSNull.NULL;
                break;
            }
            default: {
                String operator = this.readOperator();
                retval = operator.trim().length() == 0 ? null : PDFOperator.getOperator(operator);
            }
        }
        return retval;
    }

    private boolean hasNoFollowingBinData(PushbackInputStream pdfSource) throws IOException {
        int readBytes = pdfSource.read(this.binCharTestArr, 0, 10);
        boolean noBinData = true;
        int startOpIdx = -1;
        int endOpIdx = -1;
        if (readBytes > 0) {
            for (int bIdx = 0; bIdx < readBytes; ++bIdx) {
                byte b = this.binCharTestArr[bIdx];
                if (b < 9 || b > 10 && b < 32 && b != 13) {
                    noBinData = false;
                    break;
                }
                if (startOpIdx == -1 && b != 9 && b != 32 && b != 10 && b != 13) {
                    startOpIdx = bIdx;
                    continue;
                }
                if (startOpIdx == -1 || endOpIdx != -1 || b != 9 && b != 32 && b != 10 && b != 13) continue;
                endOpIdx = bIdx;
            }
            if (readBytes == 10) {
                if (startOpIdx != -1 && endOpIdx == -1) {
                    endOpIdx = 10;
                }
                if (endOpIdx != -1 && startOpIdx != -1 && endOpIdx - startOpIdx > 3) {
                    noBinData = false;
                }
            }
            pdfSource.unread(this.binCharTestArr, 0, readBytes);
        }
        if (!noBinData) {
            LOG.warn("ignoring 'EI' assumed to be in the middle of inline image");
        }
        return noBinData;
    }

    protected String readOperator() throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer(4);
        int nextChar = this.pdfSource.peek();
        while (!(nextChar == -1 || this.isWhitespace(nextChar) || this.isClosing(nextChar) || nextChar == 91 || nextChar == 60 || nextChar == 40 || nextChar == 47 || nextChar >= 48 && nextChar <= 57)) {
            char currentChar = (char)this.pdfSource.read();
            nextChar = this.pdfSource.peek();
            buffer.append(currentChar);
            if (currentChar != 'd' || nextChar != 48 && nextChar != 49) continue;
            buffer.append((char)this.pdfSource.read());
            nextChar = this.pdfSource.peek();
        }
        return buffer.toString();
    }

    private boolean isSpaceOrReturn(int c) {
        return c == 10 || c == 13 || c == 32;
    }

    private boolean hasNextSpaceOrReturn() throws IOException {
        return this.isSpaceOrReturn(this.pdfSource.peek());
    }

    @Override
    public void clearResources() {
        super.clearResources();
        if (this.streamObjects != null) {
            this.streamObjects.clear();
            this.streamObjects = null;
        }
    }
}

