/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class ExportFDF {
    public static void main(String[] args) throws Exception {
        ExportFDF exporter = new ExportFDF();
        exporter.exportFDF(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFDF(String[] args) throws Exception {
        PDDocument pdf = null;
        FDFDocument fdf = null;
        try {
            if (args.length != 1 && args.length != 2) {
                ExportFDF.usage();
            } else {
                pdf = PDDocument.load(args[0]);
                PDAcroForm form = pdf.getDocumentCatalog().getAcroForm();
                if (form == null) {
                    System.err.println("Error: This PDF does not contain a form.");
                } else {
                    String fdfName = null;
                    if (args.length == 2) {
                        fdfName = args[1];
                    } else if (args[0].length() > 4) {
                        fdfName = args[0].substring(0, args[0].length() - 4) + ".fdf";
                    }
                    fdf = form.exportFDF();
                    fdf.save(fdfName);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(fdf);
            this.close(pdf);
            throw throwable;
        }
        this.close(fdf);
        this.close(pdf);
    }

    private static void usage() {
        System.err.println("usage: org.apache.pdfbox.ExortFDF <pdf-file> [output-fdf-file]");
        System.err.println("    [output-fdf-file] - Default is pdf name, test.pdf->test.fdf");
    }

    public void close(FDFDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }
}

