/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.onenote.CompactID;
import org.apache.tika.parser.microsoft.onenote.ExtendedGUID;
import org.apache.tika.parser.microsoft.onenote.FileChunkReference;
import org.apache.tika.parser.microsoft.onenote.FileDataStoreObjectReference;
import org.apache.tika.parser.microsoft.onenote.FileNode;
import org.apache.tika.parser.microsoft.onenote.FileNodeList;
import org.apache.tika.parser.microsoft.onenote.FileNodePtr;
import org.apache.tika.parser.microsoft.onenote.FndStructureConstants;
import org.apache.tika.parser.microsoft.onenote.OneNoteDirectFileResource;
import org.apache.tika.parser.microsoft.onenote.OneNoteDocument;
import org.apache.tika.parser.microsoft.onenote.OneNotePropertyEnum;
import org.apache.tika.parser.microsoft.onenote.OneNotePropertyId;
import org.apache.tika.parser.microsoft.onenote.OneNotePtr;
import org.apache.tika.parser.microsoft.onenote.OneNoteTreeWalkerOptions;
import org.apache.tika.parser.microsoft.onenote.PropertySet;
import org.apache.tika.parser.microsoft.onenote.PropertyValue;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class OneNoteTreeWalker {
    private static final String P = "p";
    private static final long TIME32_EPOCH_DIFF_1980;
    private static final long DATETIME_EPOCH_DIFF_1601;
    private static final Pattern HYPERLINK_PATTERN;
    private final Metadata parentMetadata;
    private final EmbeddedDocumentExtractor embeddedDocumentExtractor;
    private final Set<String> authors = new HashSet<String>();
    private final Set<String> mostRecentAuthors = new HashSet<String>();
    private final Set<String> originalAuthors = new HashSet<String>();
    private final OneNoteTreeWalkerOptions options;
    private final OneNoteDocument oneNoteDocument;
    private final OneNoteDirectFileResource dif;
    private final XHTMLContentHandler xhtml;
    private final Pair<Long, ExtendedGUID> roleAndContext;
    private Instant lastModifiedTimestamp = Instant.MIN;
    private long creationTimestamp = Long.MAX_VALUE;
    private long lastModified = Long.MIN_VALUE;
    private boolean mostRecentAuthorProp = false;
    private boolean originalAuthorProp = false;
    private final Set<Pair<Long, Integer>> textAlreadyFetched = new HashSet<Pair<Long, Integer>>();

    public OneNoteTreeWalker(OneNoteTreeWalkerOptions options, OneNoteDocument oneNoteDocument, OneNoteDirectFileResource dif, XHTMLContentHandler xhtml, Metadata parentMetadata, ParseContext parseContext, Pair<Long, ExtendedGUID> roleAndContext) {
        this.options = options;
        this.oneNoteDocument = oneNoteDocument;
        this.dif = dif;
        this.roleAndContext = roleAndContext;
        this.xhtml = xhtml;
        this.parentMetadata = parentMetadata;
        this.embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)parseContext);
    }

    public Map<String, Object> walkTree() throws IOException, TikaException, SAXException {
        HashMap<String, Object> structure = new HashMap<String, Object>();
        structure.put("header", this.oneNoteDocument.header);
        structure.put("rootFileNodes", this.walkRootFileNodes());
        return structure;
    }

    public List<Map<String, Object>> walkRootFileNodes() throws IOException, TikaException, SAXException {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        if (this.options.isCrawlAllFileNodesFromRoot()) {
            res.add(this.walkFileNodeList(this.oneNoteDocument.root, null));
        } else {
            for (ExtendedGUID revisionListGuid : this.oneNoteDocument.revisionListOrder) {
                HashMap<String, Object> structure = new HashMap<String, Object>();
                structure.put("oneNoteType", "Revision");
                structure.put("revisionListGuid", revisionListGuid.toString());
                FileNodePtr fileNodePtr = this.oneNoteDocument.revisionManifestLists.get(revisionListGuid);
                structure.put("fileNode", this.walkRevision(fileNodePtr));
                res.add(structure);
            }
        }
        return res;
    }

    private boolean hasRevisionRole(ExtendedGUID rid, Pair<Long, ExtendedGUID> revisionRole) {
        Pair<Long, ExtendedGUID> where = this.oneNoteDocument.revisionRoleMap.get(rid);
        return where != null && where.equals(revisionRole);
    }

    private Map<String, Object> walkRevision(FileNodePtr fileNodePtr) throws IOException, TikaException, SAXException {
        HashMap<String, Object> structure = new HashMap<String, Object>();
        structure.put("oneNoteType", "FileNodePointer");
        structure.put("offsets", fileNodePtr.nodeListPositions);
        FileNode revisionFileNode = fileNodePtr.dereference(this.oneNoteDocument);
        structure.put("fileNodeId", revisionFileNode.id);
        if (revisionFileNode.gosid != null) {
            structure.put("gosid", revisionFileNode.gosid.toString());
        }
        structure.put("subType", revisionFileNode.subType);
        structure.put("size", revisionFileNode.size);
        structure.put("isFileData", revisionFileNode.isFileData);
        HashSet<ExtendedGUID> validRevisions = new HashSet<ExtendedGUID>();
        for (int i = revisionFileNode.childFileNodeList.children.size() - 1; i >= 0; --i) {
            FileNode child = revisionFileNode.childFileNodeList.children.get(i);
            if (this.roleAndContext == null || !this.hasRevisionRole(child.gosid, this.roleAndContext)) continue;
            validRevisions.add(child.gosid);
            if (this.options.isOnlyLatestRevision()) break;
        }
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        boolean okGroup = false;
        for (FileNode child : revisionFileNode.childFileNodeList.children) {
            if (child.id == 27L || child.id == 30L || child.id == 31L) {
                okGroup = validRevisions.contains(child.gosid);
            }
            if (!okGroup || child.id != 89L && child.id != 90L || child.subType.rootObjectReference.rootObjectReferenceBase.rootRole != 1L) continue;
            FileNodePtr childFileNodePointer = this.oneNoteDocument.guidToObject.get(child.gosid);
            children.add(this.walkFileNodePtr(childFileNodePointer, null));
        }
        if (!children.isEmpty()) {
            HashMap<String, Object> childFileNodeListMap = new HashMap<String, Object>();
            childFileNodeListMap.put("fileNodeListHeader", revisionFileNode.childFileNodeList.fileNodeListHeader);
            childFileNodeListMap.put("children", children);
            structure.put("revisionFileNodeList", childFileNodeListMap);
        }
        return structure;
    }

    public Map<String, Object> walkFileNodePtr(FileNodePtr fileNodePtr, OneNotePropertyId parentPropertyId) throws IOException, TikaException, SAXException {
        if (fileNodePtr != null) {
            FileNode fileNode = fileNodePtr.dereference(this.oneNoteDocument);
            return this.walkFileNode(fileNode, parentPropertyId);
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> walkFileNodeList(FileNodeList fileNodeList, OneNotePropertyId parentPropertyId) throws IOException, TikaException, SAXException {
        HashMap<String, Object> structure = new HashMap<String, Object>();
        structure.put("oneNoteType", "FileNodeList");
        structure.put("fileNodeListHeader", fileNodeList.fileNodeListHeader);
        if (!fileNodeList.children.isEmpty()) {
            ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
            for (FileNode child : fileNodeList.children) {
                children.add(this.walkFileNode(child, parentPropertyId));
            }
            structure.put("children", children);
        }
        return structure;
    }

    public Map<String, Object> walkFileNode(FileNode fileNode, OneNotePropertyId parentPropertyId) throws IOException, TikaException, SAXException {
        List<Map<String, Object>> propSet;
        HashMap<String, Object> structure = new HashMap<String, Object>();
        structure.put("oneNoteType", "FileNode");
        structure.put("gosid", fileNode.gosid.toString());
        structure.put("size", fileNode.size);
        structure.put("fileNodeId", "0x" + Long.toHexString(fileNode.id));
        structure.put("fileNodeIdName", FndStructureConstants.nameOf(fileNode.id));
        structure.put("fileNodeBaseType", "0x" + Long.toHexString(fileNode.baseType));
        structure.put("isFileData", fileNode.isFileData);
        structure.put("idDesc", fileNode.idDesc);
        if (fileNode.childFileNodeList != null && fileNode.childFileNodeList.fileNodeListHeader != null) {
            structure.put("childFileNodeList", this.walkFileNodeList(fileNode.childFileNodeList, parentPropertyId));
        }
        if (fileNode.propertySet != null && !(propSet = this.processPropertySet(fileNode.propertySet, parentPropertyId)).isEmpty()) {
            structure.put("propertySet", propSet);
        }
        if (fileNode.subType.fileDataStoreObjectReference.ref != null && !FileChunkReference.nil().equals(fileNode.subType.fileDataStoreObjectReference.ref.fileData)) {
            structure.put("fileDataStoreObjectReference", this.walkFileDataStoreObjectReference(fileNode.subType.fileDataStoreObjectReference));
        }
        return structure;
    }

    private Map<String, Object> walkFileDataStoreObjectReference(FileDataStoreObjectReference fileDataStoreObjectReference) throws IOException, SAXException, TikaException {
        HashMap<String, Object> structure = new HashMap<String, Object>();
        OneNotePtr content = new OneNotePtr(this.oneNoteDocument, this.dif);
        content.reposition(fileDataStoreObjectReference.ref.fileData);
        if (fileDataStoreObjectReference.ref.fileData.cb > this.dif.size()) {
            throw new TikaMemoryLimitException("File data store cb " + fileDataStoreObjectReference.ref.fileData.cb + " exceeds document size: " + this.dif.size());
        }
        this.handleEmbedded((int)fileDataStoreObjectReference.ref.fileData.cb);
        structure.put("fileDataStoreObjectMetadata", fileDataStoreObjectReference);
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbedded(int length) throws TikaException, IOException, SAXException {
        ByteBuffer buf;
        TikaInputStream stream = null;
        try {
            buf = ByteBuffer.allocate(length);
            this.dif.read(buf);
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
            return;
        }
        Metadata embeddedMetadata = new Metadata();
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            this.xhtml.startElement("div", attributes);
            this.xhtml.endElement("div");
            stream = TikaInputStream.get((byte[])buf.array());
            this.embeddedDocumentExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.xhtml), embeddedMetadata, false);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    private List<Map<String, Object>> processPropertySet(PropertySet propertySet, OneNotePropertyId parentPropertyId) throws IOException, TikaException, SAXException {
        ArrayList<Map<String, Object>> propValues = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < propertySet.rgPridsData.size(); ++i) {
            PropertyValue propertyValue = propertySet.rgPridsData.get(i);
            propValues.add(this.processPropertyValue(propertyValue, parentPropertyId));
        }
        return propValues;
    }

    private boolean propertyIsBinary(OneNotePropertyEnum property) {
        return property == OneNotePropertyEnum.RgOutlineIndentDistance || property == OneNotePropertyEnum.NotebookManagementEntityGuid || property == OneNotePropertyEnum.RichEditTextUnicode;
    }

    private Map<String, Object> processPropertyValue(PropertyValue propertyValue, OneNotePropertyId parentPropertyId) throws IOException, TikaException, SAXException {
        List<Map<String, Object>> propSet;
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("oneNoteType", "PropertyValue");
        propMap.put("propertyId", propertyValue.propertyId.toString());
        if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.LastModifiedTimeStamp) {
            long fullval = propertyValue.scalar;
            Instant instant = Instant.ofEpochSecond(fullval / 10000000L + DATETIME_EPOCH_DIFF_1601);
            if (instant.isAfter(this.lastModifiedTimestamp)) {
                this.lastModifiedTimestamp = instant;
            }
        } else if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.CreationTimeStamp) {
            long creationTs = propertyValue.scalar + TIME32_EPOCH_DIFF_1980;
            if (creationTs < this.creationTimestamp) {
                this.creationTimestamp = creationTs;
            }
        } else if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.LastModifiedTime) {
            long lastMod = propertyValue.scalar + TIME32_EPOCH_DIFF_1980;
            if (lastMod > this.lastModified) {
                this.lastModified = lastMod;
            }
        } else if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.Author) {
            String author = this.getAuthor(propertyValue);
            if (this.mostRecentAuthorProp) {
                propMap.put("MostRecentAuthor", author);
                this.mostRecentAuthors.add(author);
            } else if (this.originalAuthorProp) {
                propMap.put("OriginalAuthor", author);
                this.originalAuthors.add(author);
            } else {
                propMap.put("Author", author);
                this.authors.add(author);
            }
            this.mostRecentAuthorProp = false;
            this.originalAuthorProp = false;
        } else if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.AuthorMostRecent) {
            this.mostRecentAuthorProp = true;
        } else if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.AuthorOriginal) {
            this.originalAuthorProp = true;
        } else if (propertyValue.propertyId.type > 0L && propertyValue.propertyId.type <= 6L) {
            propMap.put("scalar", propertyValue.scalar);
        } else {
            ByteBuffer buf;
            OneNotePtr content = new OneNotePtr(this.oneNoteDocument, this.dif);
            content.reposition(propertyValue.rawData);
            boolean isBinary = this.propertyIsBinary(propertyValue.propertyId.propertyEnum);
            propMap.put("isBinary", isBinary);
            if ((content.size() & 1) == 0 && propertyValue.propertyId.propertyEnum != OneNotePropertyEnum.TextExtendedAscii && !isBinary) {
                if ((long)content.size() > this.dif.size()) {
                    throw new TikaMemoryLimitException("File data store cb " + content.size() + " exceeds document size: " + this.dif.size());
                }
                buf = ByteBuffer.allocate(content.size());
                this.dif.read(buf);
                propMap.put("dataUnicode16LE", new String(buf.array(), StandardCharsets.UTF_16LE));
                if (this.options.getUtf16PropertiesToPrint().contains((Object)propertyValue.propertyId.propertyEnum)) {
                    this.xhtml.startElement(P);
                    this.xhtml.characters((String)propMap.get("dataUnicode16LE"));
                    this.xhtml.endElement(P);
                }
            } else if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.TextExtendedAscii) {
                if ((long)content.size() > this.dif.size()) {
                    throw new TikaMemoryLimitException("File data store cb " + content.size() + " exceeds document size: " + this.dif.size());
                }
                buf = ByteBuffer.allocate(content.size());
                this.dif.read(buf);
                propMap.put("dataAscii", new String(buf.array(), StandardCharsets.US_ASCII));
                this.xhtml.startElement(P);
                this.xhtml.characters((String)propMap.get("dataAscii"));
                this.xhtml.endElement(P);
            } else if (!isBinary) {
                if ((long)content.size() > this.dif.size()) {
                    throw new TikaMemoryLimitException("File data store cb " + content.size() + " exceeds document size: " + this.dif.size());
                }
                buf = ByteBuffer.allocate(content.size());
                this.dif.read(buf);
                propMap.put("dataUnicode16LE", new String(buf.array(), StandardCharsets.UTF_16LE));
                if (this.options.getUtf16PropertiesToPrint().contains((Object)propertyValue.propertyId.propertyEnum)) {
                    this.xhtml.startElement(P);
                    this.xhtml.characters((String)propMap.get("dataUnicode16LE"));
                    this.xhtml.endElement(P);
                }
            } else {
                if ((long)content.size() > this.dif.size()) {
                    throw new TikaMemoryLimitException("File data store cb " + content.size() + " exceeds document size: " + this.dif.size());
                }
                if (propertyValue.propertyId.propertyEnum == OneNotePropertyEnum.RichEditTextUnicode && (!this.options.isOnlyLatestRevision() || parentPropertyId != null && parentPropertyId.propertyEnum != OneNotePropertyEnum.ElementChildNodesOfVersionHistory)) {
                    this.handleRichEditTextUnicode(content.size());
                }
            }
        }
        if (propertyValue.compactIDs != null) {
            ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
            for (CompactID compactID : propertyValue.compactIDs) {
                FileNodePtr childFileNodePointer = this.oneNoteDocument.guidToObject.get(compactID.guid);
                children.add(this.walkFileNodePtr(childFileNodePointer, propertyValue.propertyId));
            }
            if (!children.isEmpty()) {
                propMap.put("children", children);
            }
        }
        if (propertyValue.propertySet != null && propertyValue.propertySet.rgPridsData != null && !(propSet = this.processPropertySet(propertyValue.propertySet, parentPropertyId)).isEmpty()) {
            propMap.put("propertySet", propSet);
        }
        return propMap;
    }

    private String getAuthor(PropertyValue propertyValue) throws IOException, TikaMemoryLimitException {
        OneNotePtr content = new OneNotePtr(this.oneNoteDocument, this.dif);
        content.reposition(propertyValue.rawData);
        if ((long)content.size() > this.dif.size()) {
            throw new TikaMemoryLimitException("File data store cb " + content.size() + " exceeds document size: " + this.dif.size());
        }
        ByteBuffer buf = ByteBuffer.allocate(content.size());
        this.dif.read(buf);
        return new String(buf.array(), StandardCharsets.UTF_16LE);
    }

    private void handleRichEditTextUnicode(int length) throws SAXException, IOException {
        if (!this.textAlreadyFetched.add((Pair<Long, Integer>)Pair.of((Object)this.dif.position(), (Object)length))) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocate(length);
        this.dif.read(buf);
        byte[] arr = buf.array();
        int firstNull = 0;
        for (int i = 0; i < arr.length - 1; i += 2) {
            if (arr[i] != 0 || arr[i + 1] != 0) continue;
            firstNull = i > 0 ? i : 0;
            break;
        }
        if (firstNull == 0) {
            return;
        }
        String txt = new String(arr, 0, firstNull, StandardCharsets.UTF_16LE);
        Matcher m = HYPERLINK_PATTERN.matcher(txt);
        if (m.find()) {
            this.xhtml.startElement("a", "href", m.group(1));
            this.xhtml.characters(m.group(2));
            this.xhtml.endElement("a");
        } else {
            this.xhtml.startElement(P);
            this.xhtml.characters(txt);
            this.xhtml.endElement(P);
        }
    }

    public Set<String> getAuthors() {
        return this.authors;
    }

    public Set<String> getMostRecentAuthors() {
        return this.mostRecentAuthors;
    }

    public Set<String> getOriginalAuthors() {
        return this.originalAuthors;
    }

    public Instant getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    static {
        HYPERLINK_PATTERN = Pattern.compile("\ufddfHYPERLINK\\s+\"([^\"]+)\"([^\"]+)$");
        LocalDateTime time32Epoch1980 = LocalDateTime.of(1980, Month.JANUARY, 1, 0, 0);
        Instant instant = time32Epoch1980.atZone(ZoneOffset.UTC).toInstant();
        TIME32_EPOCH_DIFF_1980 = (instant.toEpochMilli() - Instant.EPOCH.toEpochMilli()) / 1000L;
        LocalDateTime time32Epoch1601 = LocalDateTime.of(1601, Month.JANUARY, 1, 0, 0);
        instant = time32Epoch1601.atZone(ZoneOffset.UTC).toInstant();
        DATETIME_EPOCH_DIFF_1601 = (instant.toEpochMilli() - Instant.EPOCH.toEpochMilli()) / 1000L;
    }
}

