/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderEnd;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;

public class StreamObjectHeaderEnd8bit
extends StreamObjectHeaderEnd {
    public StreamObjectHeaderEnd8bit(int type) throws TikaException {
        this.type = StreamObjectTypeHeaderEnd.fromIntVal(type);
        if (this.type == null) {
            throw new TikaException(String.format(Locale.US, "The type value %s is not defined for the stream object end 8 bit header", type));
        }
    }

    public StreamObjectHeaderEnd8bit() {
    }

    public StreamObjectHeaderEnd8bit(StreamObjectTypeHeaderEnd type) throws TikaException {
        this(type.getIntVal());
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitFieldWriter = new BitWriter(1);
        bitFieldWriter.appendInit32(1, 2);
        bitFieldWriter.appendUInit32(this.type.getIntVal(), 6);
        return bitFieldWriter.getByteList();
    }

    public byte toByte() throws IOException {
        List<Byte> bytes = this.serializeToByteList();
        if (bytes.size() != 1) {
            throw new IOException("The unexpected StreamObjectHeaderEnd8bit length");
        }
        return bytes.get(0);
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException, TikaException {
        BitReader reader = new BitReader(byteArray, startIndex);
        int headerType = reader.readInt32(2);
        if (headerType != 1) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderEnd8bit header type value, expect value %s, but actual value is %s", 1, headerType));
        }
        int typeValue = reader.readUInt32(6);
        this.type = StreamObjectTypeHeaderEnd.fromIntVal(typeValue);
        if (this.type == null) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderEnd8bit type value, the value %s is not defined", typeValue));
        }
        return 1;
    }
}

