/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;

public abstract class Suggester {
    protected final EnumMap<Hint, Object> hints = new EnumMap(Hint.class);
    Policy.Session session;
    SolrRequest operation;
    boolean force;
    protected List<Violation> originalViolations = new ArrayList<Violation>();
    private boolean isInitialized = false;

    void _init(Policy.Session session) {
        this.session = session.copy();
    }

    public Suggester hint(Hint hint, Object value) {
        hint.validator.accept(value);
        if (hint.multiValued) {
            List<Object> values = value instanceof Collection ? (List<Object>)value : Collections.singletonList(value);
            ((Set)this.hints.computeIfAbsent(hint, h -> new HashSet())).addAll(values);
        } else {
            this.hints.put(hint, (Object)(value == null ? null : String.valueOf(value)));
        }
        return this;
    }

    public Suggester forceOperation(boolean force) {
        this.force = force;
        return this;
    }

    abstract SolrRequest init();

    public SolrRequest getSuggestion() {
        if (!this.isInitialized) {
            Set srcNodes;
            Set collections = this.hints.getOrDefault((Object)Hint.COLL, Collections.emptySet());
            Set s = this.hints.getOrDefault((Object)Hint.COLL_SHARD, Collections.emptySet());
            if (!collections.isEmpty() || !s.isEmpty()) {
                HashSet shards = new HashSet(s);
                collections.stream().forEach(c -> shards.add(new Pair<String, Object>((String)c, null)));
                ClusterStateProvider stateProvider = this.session.cloudManager.getClusterStateProvider();
                for (Pair shard : shards) {
                    if (this.session.matrix.stream().noneMatch(row -> row.collectionVsShardVsReplicas.containsKey(shard.first()))) {
                        this.session.addClausesForCollection(stateProvider, (String)shard.first());
                    }
                    for (Row row2 : this.session.matrix) {
                        Map shardInfo = row2.collectionVsShardVsReplicas.computeIfAbsent((String)shard.first(), (Function<String, Map<String, List<ReplicaInfo>>>)((Function<String, Map>)it -> new HashMap()));
                        if (shard.second() == null) continue;
                        shardInfo.computeIfAbsent(shard.second(), it -> new ArrayList());
                    }
                }
                Collections.sort(this.session.expandedClauses);
            }
            if ((srcNodes = (Set)this.hints.get((Object)Hint.SRC_NODE)) != null && !srcNodes.isEmpty()) {
                for (String srcNode : srcNodes) {
                    if (!this.session.matrix.stream().noneMatch(row -> row.node.equals(srcNode))) continue;
                    this.session.matrix.add(new Row(srcNode, this.session.getPolicy().params, this.session.getPolicy().perReplicaAttributes, this.session.cloudManager));
                }
            }
            this.session.applyRules();
            this.originalViolations.addAll(this.session.getViolations());
            this.operation = this.init();
            this.isInitialized = true;
        }
        return this.operation;
    }

    public Policy.Session getSession() {
        return this.session;
    }

    List<Row> getMatrix() {
        return this.session.matrix;
    }

    boolean isLessSerious(List<Violation> fresh, List<Violation> old) {
        if (old == null || fresh.size() < old.size()) {
            return true;
        }
        if (fresh.size() == old.size()) {
            for (int i = 0; i < fresh.size(); ++i) {
                Violation freshViolation = fresh.get(i);
                Violation oldViolation = null;
                for (Violation v : old) {
                    if (!v.equals(freshViolation)) continue;
                    oldViolation = v;
                }
                if (oldViolation == null || !freshViolation.isLessSerious(oldViolation)) continue;
                return true;
            }
        }
        return false;
    }

    boolean containsNewErrors(List<Violation> violations) {
        for (Violation v : violations) {
            int idx = this.originalViolations.indexOf(v);
            if (idx >= 0 && !this.originalViolations.get(idx).isLessSerious(v)) continue;
            return true;
        }
        return false;
    }

    List<Pair<ReplicaInfo, Row>> getValidReplicas(boolean sortDesc, boolean isSource, int until) {
        ArrayList<Pair<ReplicaInfo, Row>> allPossibleReplicas = new ArrayList<Pair<ReplicaInfo, Row>>();
        if (sortDesc) {
            if (until == -1) {
                until = this.getMatrix().size();
            }
            for (int i = 0; i < until; ++i) {
                this.addReplicaToList(this.getMatrix().get(i), isSource, allPossibleReplicas);
            }
        } else {
            if (until == -1) {
                until = 0;
            }
            for (int i = this.getMatrix().size() - 1; i >= until; --i) {
                this.addReplicaToList(this.getMatrix().get(i), isSource, allPossibleReplicas);
            }
        }
        return allPossibleReplicas;
    }

    void addReplicaToList(Row r, boolean isSource, List<Pair<ReplicaInfo, Row>> replicaList) {
        if (!this.isAllowed(r.node, isSource ? Hint.SRC_NODE : Hint.TARGET_NODE)) {
            return;
        }
        for (Map.Entry<String, Map<String, List<ReplicaInfo>>> e : r.collectionVsShardVsReplicas.entrySet()) {
            if (!this.isAllowed(e.getKey(), Hint.COLL)) continue;
            for (Map.Entry<String, List<ReplicaInfo>> shard : e.getValue().entrySet()) {
                if (!this.isAllowed(new Pair<String, String>(e.getKey(), shard.getKey()), Hint.COLL_SHARD) || shard.getValue() == null || shard.getValue().isEmpty()) continue;
                replicaList.add(new Pair<ReplicaInfo, Row>(shard.getValue().get(0), r));
            }
        }
    }

    List<Violation> testChangedMatrix(boolean strict, List<Row> rows) {
        Policy.setApproxValuesAndSortNodes(this.session.getPolicy().clusterPreferences, rows);
        ArrayList<Violation> errors = new ArrayList<Violation>();
        for (Clause clause : this.session.expandedClauses) {
            List<Violation> errs;
            if (!strict && !clause.strict || (errs = clause.test(rows)).isEmpty()) continue;
            errors.addAll(errs);
        }
        return errors;
    }

    ArrayList<Row> getModifiedMatrix(List<Row> matrix, Row tmpRow, int i) {
        ArrayList<Row> copy = new ArrayList<Row>(matrix);
        copy.set(i, tmpRow);
        return copy;
    }

    protected boolean isAllowed(Object v, Hint hint) {
        Object hintVal = this.hints.get((Object)hint);
        if (hint.multiValued) {
            Set set = (Set)hintVal;
            return set == null || set.contains(v);
        }
        return hintVal == null || Objects.equals(v, hintVal);
    }

    public static enum Hint {
        COLL(true),
        COLL_SHARD(true, v -> {
            Set<Object> c = v instanceof Collection ? (Set<Object>)v : Collections.singleton(v);
            for (Object e : c) {
                if (!(e instanceof Pair)) {
                    throw new RuntimeException("SHARD hint must use a Pair");
                }
                Pair p = (Pair)e;
                if (p.first() != null && p.second() != null) continue;
                throw new RuntimeException("Both collection and shard must not be null");
            }
        }),
        SRC_NODE(true),
        TARGET_NODE(true),
        REPLICATYPE(false, o -> {
            if (!(o instanceof Replica.Type)) {
                throw new RuntimeException("REPLICATYPE hint must use a ReplicaType");
            }
        });

        public final boolean multiValued;
        public final Consumer<Object> validator;

        private Hint(boolean multiValued) {
            this(multiValued, v -> {
                Set<Object> c = v instanceof Collection ? (Set<Object>)v : Collections.singleton(v);
                for (Object e : c) {
                    if (e instanceof String) continue;
                    throw new RuntimeException("hint must be of type String");
                }
            });
        }

        private Hint(boolean multiValued, Consumer<Object> c) {
            this.multiValued = multiValued;
            this.validator = c;
        }
    }

    public static class SuggestionInfo
    implements MapWriter {
        Violation violation;
        SolrRequest operation;

        public SuggestionInfo(Violation violation, SolrRequest op) {
            this.violation = violation;
            this.operation = op;
        }

        public SolrRequest getOperation() {
            return this.operation;
        }

        public Violation getViolation() {
            return this.violation;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put("type", this.violation == null ? "improvement" : "violation");
            ew.putIfNotNull("violation", this.violation);
            ew.put("operation", this.operation);
        }

        public String toString() {
            return Utils.toJSONString(this);
        }
    }
}

