/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authz;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.filter.authz.IpAddressMatcher;
import org.apache.shiro.web.filter.authz.IpSource;

public class IpFilter
extends AuthorizationFilter {
    private static final IpSource DEFAULT_IP_SOURCE = new IpSource(){

        @Override
        public Collection<String> getAuthorizedIps() {
            return Collections.emptySet();
        }

        @Override
        public Collection<String> getDeniedIps() {
            return Collections.emptySet();
        }
    };
    private IpSource ipSource = DEFAULT_IP_SOURCE;
    private List<IpAddressMatcher> authorizedIpMatchers = Collections.emptyList();
    private List<IpAddressMatcher> deniedIpMatchers = Collections.emptyList();

    public void setAuthorizedIps(String authorizedIps) {
        String[] ips = StringUtils.tokenizeToStringArray((String)authorizedIps, (String)", \t");
        if (ips != null && ips.length > 0) {
            this.authorizedIpMatchers = new ArrayList<IpAddressMatcher>();
            for (String ip : ips) {
                this.authorizedIpMatchers.add(new IpAddressMatcher(ip));
            }
        }
    }

    public void setDeniedIps(String deniedIps) {
        String[] ips = StringUtils.tokenizeToStringArray((String)deniedIps, (String)", \t");
        if (ips != null && ips.length > 0) {
            this.deniedIpMatchers = new ArrayList<IpAddressMatcher>();
            for (String ip : ips) {
                this.deniedIpMatchers.add(new IpAddressMatcher(ip));
            }
        }
    }

    public void setIpSource(IpSource source) {
        this.ipSource = source;
    }

    public String getHostFromRequest(ServletRequest request) {
        return request.getRemoteAddr();
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        IpAddressMatcher matcher;
        String remoteIp = this.getHostFromRequest(request);
        for (IpAddressMatcher matcher2 : this.deniedIpMatchers) {
            if (!matcher2.matches(remoteIp)) continue;
            return false;
        }
        for (String ip : this.ipSource.getDeniedIps()) {
            matcher = new IpAddressMatcher(ip);
            if (!matcher.matches(remoteIp)) continue;
            return false;
        }
        for (IpAddressMatcher matcher2 : this.authorizedIpMatchers) {
            if (!matcher2.matches(remoteIp)) continue;
            return true;
        }
        for (String ip : this.ipSource.getAuthorizedIps()) {
            matcher = new IpAddressMatcher(ip);
            if (!matcher.matches(remoteIp)) continue;
            return true;
        }
        return false;
    }
}

