/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.LogicalOperator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;

public final class ExpressionExtractUtil {
    public static Collection<AndPredicate> getAndPredicates(ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            return Collections.singletonList(ExpressionExtractUtil.createAndPredicate(expression));
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(binaryExpression.getOperator());
        LinkedList<AndPredicate> result = new LinkedList<AndPredicate>();
        if (logicalOperator.isPresent() && LogicalOperator.OR == logicalOperator.get()) {
            result.addAll(ExpressionExtractUtil.getAndPredicates(binaryExpression.getLeft()));
            result.addAll(ExpressionExtractUtil.getAndPredicates(binaryExpression.getRight()));
        } else if (logicalOperator.isPresent() && LogicalOperator.AND == logicalOperator.get()) {
            Collection<AndPredicate> predicates = ExpressionExtractUtil.getAndPredicates(binaryExpression.getRight());
            for (AndPredicate each : ExpressionExtractUtil.getAndPredicates(binaryExpression.getLeft())) {
                result.addAll(ExpressionExtractUtil.getCombinedAndPredicates(each, predicates));
            }
        } else {
            result.add(ExpressionExtractUtil.createAndPredicate(expression));
        }
        return result;
    }

    private static Collection<AndPredicate> getCombinedAndPredicates(AndPredicate current, Collection<AndPredicate> predicates) {
        LinkedList<AndPredicate> result = new LinkedList<AndPredicate>();
        for (AndPredicate each : predicates) {
            AndPredicate predicate = new AndPredicate();
            predicate.getPredicates().addAll(current.getPredicates());
            predicate.getPredicates().addAll(each.getPredicates());
            result.add(predicate);
        }
        return result;
    }

    private static AndPredicate createAndPredicate(ExpressionSegment expression) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().add(expression);
        return result;
    }

    public static List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions(Collection<ExpressionSegment> expressions) {
        ArrayList<ParameterMarkerExpressionSegment> result = new ArrayList<ParameterMarkerExpressionSegment>();
        for (ExpressionSegment each : expressions) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                result.add((ParameterMarkerExpressionSegment)each);
            }
            if (each instanceof BinaryOperationExpression) {
                result.addAll(ExpressionExtractUtil.getParameterMarkerExpressions(Collections.singletonList(((BinaryOperationExpression)each).getLeft())));
                result.addAll(ExpressionExtractUtil.getParameterMarkerExpressions(Collections.singletonList(((BinaryOperationExpression)each).getRight())));
            }
            if (!(each instanceof FunctionSegment)) continue;
            result.addAll(ExpressionExtractUtil.getParameterMarkerExpressions(((FunctionSegment)each).getParameters()));
        }
        return result;
    }

    @Generated
    private ExpressionExtractUtil() {
    }
}

