/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.engine;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.top.TopSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;

public final class TopPaginationContextEngine {
    public PaginationContext createPaginationContext(TopSegment topSegment, Collection<AndPredicate> andPredicates, List<Object> parameters) {
        Optional<PredicateSegment> rowNumberPredicate = this.getRowNumberPredicate(andPredicates, topSegment.getRowNumberAlias());
        Optional<PaginationValueSegment> offset = rowNumberPredicate.isPresent() ? this.createOffsetWithRowNumber((PredicateSegment)rowNumberPredicate.get()) : Optional.absent();
        RowNumberValueSegment rowCount = topSegment.getTop();
        return new PaginationContext((PaginationValueSegment)offset.orNull(), (PaginationValueSegment)rowCount, parameters);
    }

    private Optional<PredicateSegment> getRowNumberPredicate(Collection<AndPredicate> andPredicates, String rowNumberAlias) {
        for (AndPredicate each : andPredicates) {
            for (PredicateSegment predicate : each.getPredicates()) {
                if (!this.isRowNumberColumn(predicate, rowNumberAlias) || !this.isCompareCondition(predicate)) continue;
                return Optional.of((Object)predicate);
            }
        }
        return Optional.absent();
    }

    private boolean isRowNumberColumn(PredicateSegment predicate, String rowNumberAlias) {
        return predicate.getColumn().getName().equalsIgnoreCase(rowNumberAlias);
    }

    private boolean isCompareCondition(PredicateSegment predicate) {
        if (predicate.getRightValue() instanceof PredicateCompareRightValue) {
            String operator = ((PredicateCompareRightValue)predicate.getRightValue()).getOperator();
            return ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private Optional<PaginationValueSegment> createOffsetWithRowNumber(PredicateSegment predicateSegment) {
        ExpressionSegment expression = ((PredicateCompareRightValue)predicateSegment.getRightValue()).getExpression();
        switch (((PredicateCompareRightValue)predicateSegment.getRightValue()).getOperator()) {
            case ">": {
                return Optional.of((Object)this.createRowNumberValueSegment(expression, false));
            }
            case ">=": {
                return Optional.of((Object)this.createRowNumberValueSegment(expression, true));
            }
        }
        return Optional.absent();
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        return expression instanceof LiteralExpressionSegment ? new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, (long)((Integer)((LiteralExpressionSegment)expression).getLiterals()).intValue(), boundOpened) : new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
    }
}

