/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.impl;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DDLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.PostgreSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.value.collection.CollectionValue;

public final class PostgreSQLDDLVisitor
extends PostgreSQLVisitor
implements DDLVisitor {
    @Override
    public ASTNode visitCreateTable(PostgreSQLStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(PostgreSQLStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(PostgreSQLStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause().tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getAddConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(PostgreSQLStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterTableActions()) {
            for (PostgreSQLStatementParser.AlterTableActionContext each : ctx.alterTableActions().alterTableAction()) {
                PostgreSQLStatementParser.AddColumnSpecificationContext addColumnSpecification = each.addColumnSpecification();
                if (null != addColumnSpecification) {
                    result.getValue().addAll(((CollectionValue)this.visit((ParseTree)addColumnSpecification)).getValue());
                }
                if (null != each.addConstraintSpecification() && null != each.addConstraintSpecification().tableConstraint()) {
                    result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.addConstraintSpecification().tableConstraint()));
                }
                if (null != each.modifyColumnSpecification()) {
                    result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)each.modifyColumnSpecification()));
                }
                if (null == each.dropColumnSpecification()) continue;
                result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)each.dropColumnSpecification()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(PostgreSQLStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        PostgreSQLStatementParser.ColumnDefinitionContext columnDefinition = ctx.columnDefinition();
        if (null != columnDefinition) {
            AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(ctx.columnDefinition().getStart().getStartIndex(), columnDefinition.getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)columnDefinition)));
            result.getValue().add(addColumnDefinition);
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(PostgreSQLStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey);
        for (PostgreSQLStatementParser.ColumnConstraintContext each : ctx.columnConstraint()) {
            if (null == each.columnConstraintOption().tableName()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each.columnConstraintOption().tableName()));
        }
        return result;
    }

    private boolean isPrimaryKey(PostgreSQLStatementParser.ColumnDefinitionContext ctx) {
        for (PostgreSQLStatementParser.ColumnConstraintContext each : ctx.columnConstraint()) {
            if (null == each.columnConstraintOption() || null == each.columnConstraintOption().primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitTableConstraint(PostgreSQLStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.tableConstraintOption().primaryKey()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableConstraintOption().columnNames(0))).getValue());
        }
        if (null != ctx.tableConstraintOption().FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableConstraintOption().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(PostgreSQLStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.modifyColumn().columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false);
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(PostgreSQLStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singletonList((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitRenameColumnSpecification(PostgreSQLStatementParser.RenameColumnSpecificationContext ctx) {
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)this.visit((ParseTree)ctx.columnName(0)), (ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
    }

    @Override
    public ASTNode visitDropTable(PostgreSQLStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(PostgreSQLStatementParser.TruncateTableContext ctx) {
        TruncateStatement result = new TruncateStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNamesClause())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(PostgreSQLStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.indexName()) {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(PostgreSQLStatementParser.AlterIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement();
        result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(PostgreSQLStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement();
        result.getIndexes().addAll(((CollectionValue)this.visit((ParseTree)ctx.indexNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitIndexNames(PostgreSQLStatementParser.IndexNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getValue().add((IndexSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitTableNameClause(PostgreSQLStatementParser.TableNameClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitTableNamesClause(PostgreSQLStatementParser.TableNamesClauseContext ctx) {
        LinkedList<SimpleTableSegment> tableSegments = new LinkedList<SimpleTableSegment>();
        for (int i = 0; i < ctx.tableNameClause().size(); ++i) {
            tableSegments.add((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause(i)));
        }
        CollectionValue result = new CollectionValue();
        result.getValue().addAll(tableSegments);
        return result;
    }
}

