/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.impl;

import java.util.Collection;
import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DCLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.PostgreSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.sql.value.collection.CollectionValue;

public final class PostgreSQLDCLVisitor
extends PostgreSQLVisitor
implements DCLVisitor {
    @Override
    public ASTNode visitGrant(PostgreSQLStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement();
        if (null != ctx.privilegeClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.privilegeClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(PostgreSQLStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement();
        if (null != ctx.privilegeClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.privilegeClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(PostgreSQLStatementParser.PrivilegeClauseContext ctx) {
        return null == ctx.onObjectClause().tableNames() ? Collections.emptyList() : ((CollectionValue)this.visit((ParseTree)ctx.onObjectClause().tableNames())).getValue();
    }

    @Override
    public ASTNode visitCreateUser(PostgreSQLStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(PostgreSQLStatementParser.DropUserContext ctx) {
        return new DropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(PostgreSQLStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(PostgreSQLStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(PostgreSQLStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(PostgreSQLStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement();
    }
}

