/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.database.parser;

import lombok.Generated;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.core.database.parser.DatabaseTypedSQLParserFacadeFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.DatabaseTypedSQLParserFacade;

public final class SQLParserExecutor {
    private final String databaseType;

    public ParseASTNode parse(String sql) {
        ParseASTNode result = this.twoPhaseParse(sql);
        if (result.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException(sql);
        }
        return result;
    }

    private ParseASTNode twoPhaseParse(String sql) {
        DatabaseTypedSQLParserFacade sqlParserFacade = DatabaseTypedSQLParserFacadeFactory.getInstance(this.databaseType);
        SQLParser sqlParser = SQLParserFactory.newInstance(sql, sqlParserFacade.getLexerClass(), sqlParserFacade.getParserClass());
        try {
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.LL);
            try {
                return (ParseASTNode)sqlParser.parse();
            }
            catch (ParseCancellationException e) {
                throw new SQLParsingException(sql);
            }
        }
    }

    @Generated
    public SQLParserExecutor(String databaseType) {
        this.databaseType = databaseType;
    }
}

