/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.parser;

import lombok.Generated;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.spi.SQLParserConfiguration;

public final class SQLParserFactory {
    public static SQLParser newInstance(String databaseTypeName, String sql) {
        for (SQLParserConfiguration each : NewInstanceServiceLoader.newServiceInstances(SQLParserConfiguration.class)) {
            if (!each.getDatabaseTypeName().equals(databaseTypeName)) continue;
            return SQLParserFactory.createSQLParser(sql, each);
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type '%s'", databaseTypeName));
    }

    private static SQLParser createSQLParser(String sql, SQLParserConfiguration configuration) {
        Lexer lexer = (Lexer)configuration.getLexerClass().getConstructor(CharStream.class).newInstance(CharStreams.fromString((String)sql));
        return (SQLParser)configuration.getParserClass().getConstructor(TokenStream.class).newInstance(new CommonTokenStream((TokenSource)lexer));
    }

    @Generated
    private SQLParserFactory() {
    }

    static {
        NewInstanceServiceLoader.register(SQLParserConfiguration.class);
    }
}

