/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.segment.generic;

import com.google.common.base.Optional;
import org.apache.shardingsphere.sql.parser.core.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableAvailable;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class TableSegment
implements SQLSegment,
TableAvailable,
OwnerAvailable<SchemaSegment>,
AliasAvailable {
    private final int startIndex;
    private final int stopIndex;
    private final String name;
    private final QuoteCharacter quoteCharacter;
    private SchemaSegment owner;
    private String alias;

    public TableSegment(int startIndex, int stopIndex, String name) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.name = SQLUtil.getExactlyValue(name);
        this.quoteCharacter = QuoteCharacter.getQuoteCharacter(name);
    }

    @Override
    public int getStartIndex() {
        return null == this.owner ? this.startIndex : this.owner.getStartIndex();
    }

    @Override
    public String getTableName() {
        return this.name;
    }

    @Override
    public QuoteCharacter getTableQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Override
    public Optional<SchemaSegment> getOwner() {
        return Optional.fromNullable((Object)this.owner);
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.fromNullable((Object)this.alias);
    }

    @Override
    public void setAlias(String alias) {
        this.alias = SQLUtil.getExactlyValue(alias);
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public String toString() {
        return "TableSegment(startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", name=" + this.name + ", quoteCharacter=" + (Object)((Object)this.getQuoteCharacter()) + ", owner=" + this.getOwner() + ", alias=" + this.getAlias() + ")";
    }

    @Override
    public void setOwner(SchemaSegment owner) {
        this.owner = owner;
    }
}

