/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.segment.dml.column;

import com.google.common.base.Optional;
import org.apache.shardingsphere.sql.parser.core.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public class ColumnSegment
implements SQLSegment,
PredicateRightValue,
OwnerAvailable<TableSegment> {
    private final int startIndex;
    private final int stopIndex;
    private final String name;
    private final QuoteCharacter quoteCharacter;
    private TableSegment owner;

    public ColumnSegment(int startIndex, int stopIndex, String name) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.name = SQLUtil.getExactlyValue(name);
        this.quoteCharacter = QuoteCharacter.getQuoteCharacter(name);
    }

    public final String getQualifiedName() {
        return null == this.owner ? this.name : this.owner.getTableName() + "." + this.name;
    }

    @Override
    public final Optional<TableSegment> getOwner() {
        return Optional.fromNullable((Object)this.owner);
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public String getName() {
        return this.name;
    }

    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Override
    public void setOwner(TableSegment owner) {
        this.owner = owner;
    }

    public String toString() {
        return "ColumnSegment(startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", name=" + this.getName() + ", quoteCharacter=" + (Object)((Object)this.getQuoteCharacter()) + ", owner=" + this.getOwner() + ")";
    }
}

