/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;

public final class ExtractorUtils {
    public static ParserRuleContext getFirstChildNode(ParserRuleContext node, RuleName ruleName) {
        Optional<ParserRuleContext> result = ExtractorUtils.findFirstChildNode(node, ruleName);
        Preconditions.checkState((boolean)result.isPresent());
        return (ParserRuleContext)result.get();
    }

    public static Optional<ParserRuleContext> findFirstChildNode(ParserRuleContext node, RuleName ruleName) {
        ParserRuleContext parserRuleContext;
        LinkedList<ParserRuleContext> parserRuleContexts = new LinkedList<ParserRuleContext>();
        parserRuleContexts.add(node);
        while (null != (parserRuleContext = (ParserRuleContext)parserRuleContexts.poll())) {
            if (ExtractorUtils.isMatchedNode(parserRuleContext, ruleName)) {
                return Optional.of((Object)parserRuleContext);
            }
            for (int i = 0; i < parserRuleContext.getChildCount(); ++i) {
                if (!(parserRuleContext.getChild(i) instanceof ParserRuleContext)) continue;
                parserRuleContexts.add((ParserRuleContext)parserRuleContext.getChild(i));
            }
        }
        return Optional.absent();
    }

    public static Optional<ParserRuleContext> findFirstChildNodeNoneRecursive(ParserRuleContext node, RuleName ruleName) {
        if (ExtractorUtils.isMatchedNode(node, ruleName)) {
            return Optional.of((Object)node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ParserRuleContext child;
            if (!(node.getChild(i) instanceof ParserRuleContext) || !ExtractorUtils.isMatchedNode(child = (ParserRuleContext)node.getChild(i), ruleName)) continue;
            return Optional.of((Object)child);
        }
        return Optional.absent();
    }

    public static Optional<ParserRuleContext> findSingleNodeFromFirstDescendant(ParserRuleContext node, RuleName ruleName) {
        ParserRuleContext nextNode = node;
        do {
            if (ExtractorUtils.isMatchedNode(nextNode, ruleName)) {
                return Optional.of((Object)nextNode);
            }
            if (1 == nextNode.getChildCount() && nextNode.getChild(0) instanceof ParserRuleContext) continue;
            return Optional.absent();
        } while (null != (nextNode = (ParserRuleContext)nextNode.getChild(0)));
        return Optional.absent();
    }

    public static Collection<ParserRuleContext> getAllDescendantNodes(ParserRuleContext node, RuleName ruleName) {
        LinkedList<ParserRuleContext> result = new LinkedList<ParserRuleContext>();
        for (ParserRuleContext each : ExtractorUtils.getAllNodes(node)) {
            if (!ExtractorUtils.isMatchedNode(each, ruleName)) continue;
            result.add(each);
        }
        return result;
    }

    private static Collection<ParserRuleContext> getAllNodes(ParserRuleContext node) {
        LinkedList<ParserRuleContext> result = new LinkedList<ParserRuleContext>();
        LinkedList<ParserRuleContext> stack = new LinkedList<ParserRuleContext>();
        stack.add(node);
        while (!stack.isEmpty()) {
            ParserRuleContext each = (ParserRuleContext)stack.pop();
            result.add(each);
            ParserRuleContext[] childNodes = ExtractorUtils.getChildrenNodes(each).toArray(new ParserRuleContext[0]);
            for (int i = childNodes.length - 1; i >= 0; --i) {
                stack.push(childNodes[i]);
            }
        }
        return result;
    }

    private static boolean isMatchedNode(ParserRuleContext node, RuleName ruleName) {
        return ruleName.getName().equals(node.getClass().getSimpleName());
    }

    private static Collection<ParserRuleContext> getChildrenNodes(ParserRuleContext node) {
        LinkedList<ParserRuleContext> result = new LinkedList<ParserRuleContext>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ParseTree child = node.getChild(i);
            if (!(child instanceof ParserRuleContext)) continue;
            result.add((ParserRuleContext)child);
        }
        return result;
    }

    private ExtractorUtils() {
    }
}

