/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.cache;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class SQLParseResultCache {
    private final Cache<String, SQLStatement> cache = CacheBuilder.newBuilder().softValues().initialCapacity(2000).maximumSize(65535L).build();

    public void put(String sql, SQLStatement sqlStatement) {
        this.cache.put((Object)sql, (Object)sqlStatement);
    }

    public Optional<SQLStatement> getSQLStatement(String sql) {
        return Optional.fromNullable((Object)this.cache.getIfPresent((Object)sql));
    }

    public synchronized void clear() {
        this.cache.invalidateAll();
    }
}

