/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.item.impl;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.core.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationDistinctSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ExpressionSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.AliasAvailable;

public final class FunctionSelectItemExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<SelectItemSegment> extract(ParserRuleContext expressionNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> functionCallNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.FUNCTION_CALL);
        if (!functionCallNode.isPresent()) {
            return Optional.absent();
        }
        SelectItemSegment result = this.extractFunctionSelectItemSegment((ParserRuleContext)functionCallNode.get());
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNodeNoneRecursive(expressionNode, RuleName.ALIAS);
        if (aliasNode.isPresent() && result instanceof AliasAvailable) {
            ((AliasAvailable)((Object)result)).setAlias(((ParserRuleContext)aliasNode.get()).getText());
        }
        return Optional.of((Object)result);
    }

    private SelectItemSegment extractFunctionSelectItemSegment(ParserRuleContext functionCallNode) {
        Optional<ParserRuleContext> aggregationFunctionCallNode = ExtractorUtils.findFirstChildNodeNoneRecursive(functionCallNode, RuleName.AGGREGATION_FUNCTION);
        if (!aggregationFunctionCallNode.isPresent()) {
            return new ExpressionSelectItemSegment(functionCallNode.getStart().getStartIndex(), functionCallNode.getStop().getStopIndex(), functionCallNode.getText());
        }
        Optional<AggregationType> aggregationType = this.findAggregationType(((ParserRuleContext)aggregationFunctionCallNode.get()).getChild(0).getText());
        return (SelectItemSegment)((Object)(aggregationType.isPresent() ? this.extractAggregationSelectItemSegment((AggregationType)((Object)aggregationType.get()), (ParserRuleContext)aggregationFunctionCallNode.get()) : new ExpressionSelectItemSegment(functionCallNode.getStart().getStartIndex(), functionCallNode.getStop().getStopIndex(), functionCallNode.getText())));
    }

    private Optional<AggregationType> findAggregationType(String functionName) {
        try {
            return Optional.of((Object)((Object)AggregationType.valueOf(functionName.toUpperCase())));
        }
        catch (IllegalArgumentException ignore) {
            return Optional.absent();
        }
    }

    private AggregationSelectItemSegment extractAggregationSelectItemSegment(AggregationType type, ParserRuleContext aggregationFunctionCallNode) {
        int innerExpressionStartIndex = ((TerminalNode)aggregationFunctionCallNode.getChild(1)).getSymbol().getStartIndex();
        return ExtractorUtils.findFirstChildNode(aggregationFunctionCallNode, RuleName.DISTINCT).isPresent() ? new AggregationDistinctSelectItemSegment(aggregationFunctionCallNode.getStart().getStartIndex(), aggregationFunctionCallNode.getStop().getStopIndex(), aggregationFunctionCallNode.getText(), type, innerExpressionStartIndex, this.getDistinctExpression(aggregationFunctionCallNode)) : new AggregationSelectItemSegment(aggregationFunctionCallNode.getStart().getStartIndex(), aggregationFunctionCallNode.getStop().getStopIndex(), aggregationFunctionCallNode.getText(), type, innerExpressionStartIndex);
    }

    private String getDistinctExpression(ParserRuleContext functionNode) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < functionNode.getChildCount() - 1; ++i) {
            result.append(functionNode.getChild(i).getText());
        }
        return result.toString();
    }
}

