/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.segment.generic;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;

public final class PivotSegment
implements SQLSegment {
    private final int startIndex;
    private final int stopIndex;
    private final ColumnSegment pivotForColumn;
    private final Collection<ColumnSegment> pivotInColumns;
    private final boolean isUnPivot;
    private ColumnSegment unpivotColumn;

    public PivotSegment(int startIndex, int stopIndex, ColumnSegment pivotForColumn, Collection<ColumnSegment> pivotInColumns) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.pivotForColumn = pivotForColumn;
        this.pivotInColumns = pivotInColumns;
        this.isUnPivot = false;
    }

    public Collection<ColumnSegment> getPivotColumns() {
        HashSet<ColumnSegment> result = new HashSet<ColumnSegment>(this.pivotInColumns);
        result.add(this.pivotForColumn);
        if (null != this.unpivotColumn) {
            result.add(this.unpivotColumn);
        }
        return result;
    }

    @Generated
    public PivotSegment(int startIndex, int stopIndex, ColumnSegment pivotForColumn, Collection<ColumnSegment> pivotInColumns, boolean isUnPivot) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.pivotForColumn = pivotForColumn;
        this.pivotInColumns = pivotInColumns;
        this.isUnPivot = isUnPivot;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public ColumnSegment getPivotForColumn() {
        return this.pivotForColumn;
    }

    @Generated
    public Collection<ColumnSegment> getPivotInColumns() {
        return this.pivotInColumns;
    }

    @Generated
    public boolean isUnPivot() {
        return this.isUnPivot;
    }

    @Generated
    public ColumnSegment getUnpivotColumn() {
        return this.unpivotColumn;
    }

    @Generated
    public void setUnpivotColumn(ColumnSegment unpivotColumn) {
        this.unpivotColumn = unpivotColumn;
    }
}

